/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares;

import me.lizardofoz.drgflares.CommonEvents;
import me.lizardofoz.drgflares.DRGFlareRegistryForge;
import me.lizardofoz.drgflares.client.FlareEntityRenderer;
import me.lizardofoz.drgflares.client.FlareHUDRenderer;
import me.lizardofoz.drgflares.packet.PacketStuff;
import me.lizardofoz.drgflares.util.DRGFlareLimiter;
import me.lizardofoz.drgflares.util.DRGFlarePlayerAspect;
import me.lizardofoz.drgflares.util.FlareColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ForgeEvents
extends CommonEvents {
    public static void initialize() {
        DRGFlareLimiter.initOrReset();
        DRGFlarePlayerAspect.initOrReset();
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEvents());
        if (FMLEnvironment.dist == Dist.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new Client());
        }
    }

    private ForgeEvents() {
    }

    @SubscribeEvent
    public void onEvent(ServerStartedEvent event) {
        this.onServerStart(event.getServer());
    }

    @SubscribeEvent
    public void onEvent(PlayerEvent.PlayerLoggedInEvent event) {
        this.onPlayerJoinServer((ServerPlayer)event.getPlayer());
    }

    @SubscribeEvent
    public void onEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        this.onPlayerLeaveServer(event.getPlayer());
    }

    @SubscribeEvent
    public void onEvent(TickEvent.ServerTickEvent event) {
        this.onServerTick();
    }

    @Override
    protected void sendSettingsSyncS2CPacket(ServerPlayer player) {
        PacketStuff.sendSettingsSyncS2CPacket(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client
    extends CommonEvents.Client {
        private Client() {
            EntityRenderers.m_174036_(DRGFlareRegistryForge.instance.getFlareEntityType(), FlareEntityRenderer::new);
        }

        @SubscribeEvent
        public void onEvent(RenderGameOverlayEvent.Post event) {
            if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
                FlareHUDRenderer.render(event.getMatrixStack(), event.getPartialTicks());
            }
        }

        @SubscribeEvent
        public void onEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
            this.onClientConnect();
        }

        @SubscribeEvent
        public void onEvent(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            this.onClientDisconnect();
        }

        @SubscribeEvent
        public void onEvent(TickEvent.ClientTickEvent event) {
            this.onClientTick(Minecraft.m_91087_());
        }

        @Override
        protected void sendFlareThrowC2SPacket(FlareColor color) {
            PacketStuff.sendFlareThrowC2SPacket(color);
        }
    }
}

