/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.block;

import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.block.FlareLightBlockEntity;
import me.lizardofoz.drgflares.config.ServerSettings;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FlareLightBlock
extends BaseEntityBlock {
    public static final IntegerProperty LIGHT_LEVEL = BlockStateProperties.f_61422_;
    private static BlockState fullBrightnessBlockState;
    private static BlockState dimmedOutBlockState;

    public static void refreshBlockStates() {
        BlockState defaultState = DRGFlareRegistry.getInstance().getLightSourceBlockType().m_49966_();
        fullBrightnessBlockState = (BlockState)defaultState.m_61124_((Property)LIGHT_LEVEL, (Comparable)((Integer)ServerSettings.CURRENT.fullBrightnessLightLevel.value));
        dimmedOutBlockState = (BlockState)defaultState.m_61124_((Property)LIGHT_LEVEL, (Comparable)((Integer)ServerSettings.CURRENT.dimmedLightLevel.value));
    }

    public static int getLightLevel(Level world, BlockPos blockPos) {
        try {
            return (Integer)world.m_8055_(blockPos).m_61143_((Property)LIGHT_LEVEL);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    public FlareLightBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FlareLightBlockEntity(pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LIGHT_LEVEL});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return world.f_46443_ || (Boolean)ServerSettings.CURRENT.serverSideLightSources.value != false ? FlareLightBlock.m_152132_(type, DRGFlareRegistry.getInstance().getLightSourceBlockEntityType(), FlareLightBlockEntity::staticTick) : null;
    }

    public static BlockState getFullBrightnessBlockState() {
        return fullBrightnessBlockState;
    }

    public static BlockState getDimmedOutBlockState() {
        return dimmedOutBlockState;
    }
}

