/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.HashMap;
import java.util.Map;
import me.lizardofoz.drgflares.entity.FlareEntity;
import me.lizardofoz.drgflares.util.FlareColor;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlareEntityRenderer
extends EntityRenderer<FlareEntity> {
    private final Map<FlareColor, ResourceLocation> TEXTURES = new HashMap<FlareColor, ResourceLocation>();
    private final int MAX_LIGHT = LightTexture.m_109885_((int)15, (int)15);
    private final ModelPart rodModel = new MeshDefinition().m_171576_().m_171599_("rod", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171481_(-1.0f, -9.0f, -1.0f, 2.0f, 13.0f, 2.0f), PartPose.f_171404_).m_171583_(32, 32);
    private final ModelPart metalModel;

    public FlareEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        PartDefinition metalModelBuilder = new MeshDefinition().m_171576_();
        metalModelBuilder.m_171599_("bottom", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-2.0f, -8.0f, -2.0f, 4.0f, 2.0f, 4.0f), PartPose.f_171404_);
        metalModelBuilder.m_171599_("top", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, 1.0f, -2.0f, 4.0f, 2.0f, 4.0f), PartPose.f_171404_);
        this.metalModel = metalModelBuilder.m_171583_(32, 32);
        for (FlareColor color : FlareColor.colors) {
            this.TEXTURES.put(color, new ResourceLocation("drg_flares", "textures/entity/drg_flare_" + color.toString() + ".png"));
        }
    }

    public void render(FlareEntity entity, float yaw, float subTickTime, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        super.m_7392_((Entity)entity, yaw, subTickTime, matrices, vertexConsumers, light);
        Vec3 velocity = entity.m_20184_().m_82490_(10.0);
        entity.frame(subTickTime);
        matrices.m_85836_();
        matrices.m_85837_(0.0, (double)0.1f, 0.0);
        matrices.m_85845_(Vector3f.f_122225_.m_122240_((float)(entity.m_142049_() * 119)));
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(entity.rotation));
        matrices.m_85845_(Vector3f.f_122223_.m_122240_(Mth.m_14031_((float)((float)(velocity.f_82479_ + 90.0) / 15.0f)) * 360.0f));
        matrices.m_85845_(Vector3f.f_122225_.m_122240_(Mth.m_14089_((float)((float)(velocity.f_82480_ + velocity.f_82479_ * 200.0) / 15.0f)) * 360.0f));
        matrices.m_85841_(0.6f, 0.6f, 0.6f);
        VertexConsumer vertexConsumer = vertexConsumers.m_6299_(RenderType.m_110452_((ResourceLocation)this.TEXTURES.get((Object)entity.color)));
        this.rodModel.m_104306_(matrices, vertexConsumer, this.MAX_LIGHT, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        this.metalModel.m_104306_(matrices, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrices.m_85849_();
    }

    public ResourceLocation getTexture(FlareEntity entity) {
        return this.TEXTURES.get((Object)entity.color);
    }
}

