/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.config.PlayerSettings;
import me.lizardofoz.drgflares.config.ServerSettings;
import me.lizardofoz.drgflares.util.DRGFlarePlayerAspect;
import me.lizardofoz.drgflares.util.DRGFlaresUtil;
import me.lizardofoz.drgflares.util.FlareColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlareHUDRenderer {
    private static final ResourceLocation HUD_TEXTURE = new ResourceLocation("drg_flares", "textures/gui/hud.png");
    private static final Minecraft client = Minecraft.m_91087_();

    public static void render(PoseStack matrixStack, float tickDelta) {
        if (!((Boolean)ServerSettings.CURRENT.regeneratingFlaresEnabled.value).booleanValue() || FlareHUDRenderer.client.f_91074_ == null || FlareHUDRenderer.client.f_91074_.m_5833_()) {
            return;
        }
        int widgetX = (int)((float)client.m_91268_().m_85445_() * ((Float)PlayerSettings.INSTANCE.flareUISlotX.value).floatValue());
        int widgetY = (int)((float)client.m_91268_().m_85446_() * ((Float)PlayerSettings.INSTANCE.flareUISlotY.value).floatValue()) - 19;
        Component keyHintLabel = PlayerSettings.INSTANCE.throwFlareKey.m_90863_();
        boolean shouldRenderKeybindHint = (Boolean)PlayerSettings.INSTANCE.flareButtonHint.value != false && keyHintLabel.m_6111_().length() == 1;
        FlareColor flareColor = FlareColor.RandomColorPicker.unwrapRandom((FlareColor)((Object)PlayerSettings.INSTANCE.flareColor.value), false);
        ItemStack flareDisplayStack = new ItemStack((ItemLike)DRGFlareRegistry.getInstance().getFlareItemTypes().get((Object)flareColor));
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)HUD_TEXTURE);
        RenderSystem.m_69478_();
        GuiComponent.m_93143_((PoseStack)matrixStack, (int)(widgetX - 3), (int)(widgetY - 3), (int)-200, (float)0.0f, (float)0.0f, (int)22, (int)22, (int)32, (int)32);
        if (shouldRenderKeybindHint) {
            GuiComponent.m_93143_((PoseStack)matrixStack, (int)(widgetX + 12), (int)(widgetY - 6), (int)-200, (float)22.0f, (float)0.0f, (int)10, (int)10, (int)32, (int)32);
        }
        float zOffset = FlareHUDRenderer.client.m_91291_().f_115093_;
        FlareHUDRenderer.client.m_91291_().f_115093_ = -170.0f;
        client.m_91291_().m_115203_(flareDisplayStack, widgetX, widgetY);
        FlareHUDRenderer.client.m_91291_().f_115093_ = zOffset;
        if (!DRGFlaresUtil.hasUnlimitedRegeneratingFlares((Player)FlareHUDRenderer.client.f_91074_)) {
            int count = DRGFlarePlayerAspect.clientLocal.getFlaresLeft();
            int currentRegenStatus = DRGFlarePlayerAspect.clientLocal.getFlareRegenStatus();
            int regenBarMaxValue = (Integer)ServerSettings.CURRENT.regeneratingFlaresRechargeTime.value * 20;
            if (count < (Integer)ServerSettings.CURRENT.regeneratingFlaresMaxCharges.value) {
                RenderSystem.m_69472_();
                float h = Math.max(0.0f, (float)currentRegenStatus / (float)regenBarMaxValue);
                int i = Math.round((float)currentRegenStatus * 12.0f / (float)regenBarMaxValue);
                int j = Mth.m_14169_((float)(h / 3.0f), (float)1.0f, (float)1.0f);
                FlareHUDRenderer.renderGuiQuad(bufferBuilder, widgetX + 1, widgetY + 2, 2, 13, 0, 0, 0, 0);
                FlareHUDRenderer.renderGuiQuad(bufferBuilder, widgetX + 1, widgetY + 14 - i, 1, i, 111, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF);
                RenderSystem.m_69493_();
            }
            String countText = String.valueOf(count);
            MultiBufferSource.BufferSource provider = MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder);
            FlareHUDRenderer.client.f_91062_.m_92811_(countText, (float)(widgetX + 19 - 2 - FlareHUDRenderer.client.f_91062_.m_92895_(countText)), (float)(widgetY + 6 + 3), 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)provider, false, 0, 0xF000F0);
            provider.m_109911_();
        }
        if (shouldRenderKeybindHint) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
            MultiBufferSource.BufferSource provider = MultiBufferSource.m_109898_((BufferBuilder)bufferBuilder);
            FlareHUDRenderer.client.f_91062_.m_92841_(keyHintLabel, (float)(widgetX + 15) / 0.7f, (float)(widgetY - 4) / 0.7f, 0xFFFFFF, true, matrixStack.m_85850_().m_85861_(), (MultiBufferSource)provider, false, 0, 0xF000F0);
            provider.m_109911_();
            matrixStack.m_85849_();
        }
    }

    private static void renderGuiQuad(BufferBuilder buffer, int x, int y, int width, int height, int z, int red, int green, int blue) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        buffer.m_5483_((double)x, (double)y, (double)z).m_6122_(red, green, blue, 255).m_5752_();
        buffer.m_5483_((double)x, (double)(y + height), (double)z).m_6122_(red, green, blue, 255).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), (double)z).m_6122_(red, green, blue, 255).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, (double)z).m_6122_(red, green, blue, 255).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }
}

