/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.client;

import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.block.FlareLightBlock;
import me.lizardofoz.drgflares.config.PlayerSettings;
import me.lizardofoz.drgflares.config.ServerSettings;
import me.lizardofoz.drgflares.config.SettingsEntry;
import me.lizardofoz.drgflares.util.DRGFlaresUtil;
import me.lizardofoz.drgflares.util.FlareColor;
import me.lizardofoz.drgflares.util.ServerSyncMode;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.FloatListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SettingsScreen {
    private SettingsScreen() {
    }

    public static Screen create(Screen parent) {
        boolean editable;
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setSavingRunnable(SettingsScreen::onSave).setTitle((Component)new TranslatableComponent("drg_flares.settings.title"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ConfigCategory category = builder.getOrCreateCategory((Component)new TranslatableComponent("drg_flares.settings.title"));
        SubCategoryBuilder aboutSection = entryBuilder.startSubCategory((Component)new TranslatableComponent("drg_flares.settings.about.title"));
        aboutSection.add((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TranslatableComponent("drg_flares.settings.about.text", new Object[]{ServerSettings.CURRENT.secondsUntilDimmingOut.value, ServerSettings.CURRENT.andThenSecondsUntilFizzlingOut.value, ServerSettings.CURRENT.andThenSecondsUntilDespawn.value})).build());
        category.addEntry((AbstractConfigListEntry)aboutSection.build());
        category.addEntry((AbstractConfigListEntry)entryBuilder.startIntSlider((Component)new TranslatableComponent(PlayerSettings.INSTANCE.flareColor.displayText), ((FlareColor)((Object)PlayerSettings.INSTANCE.flareColor.value)).id, -2, 15).setDefaultValue(((FlareColor)((Object)PlayerSettings.INSTANCE.flareColor.defaultValue)).id).setSaveConsumer(it -> {
            PlayerSettings.INSTANCE.flareColor.value = FlareColor.byId(it);
        }).setTextGetter(it -> new TranslatableComponent(PlayerSettings.INSTANCE.flareColor.displayText + "." + it)).setTooltip(new Component[]{new TranslatableComponent(PlayerSettings.INSTANCE.flareColor.displayToolTip)}).build());
        SettingsScreen.addFloatEntry(category, entryBuilder, PlayerSettings.INSTANCE.flareUISlotX, true);
        SettingsScreen.addFloatEntry(category, entryBuilder, PlayerSettings.INSTANCE.flareUISlotY, true);
        SettingsScreen.addIntegerEntry(category, entryBuilder, PlayerSettings.INSTANCE.flareSoundVolume, true);
        SettingsScreen.addBoolEntry(category, entryBuilder, PlayerSettings.INSTANCE.flareButtonHint, true);
        boolean bl = editable = !DRGFlaresUtil.isOnRemoteServer();
        if (DRGFlareRegistry.getInstance().serverSyncMode == ServerSyncMode.CLIENT_ONLY) {
            editable = true;
            category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TranslatableComponent("drg_flares.settings.server_desc_client_only")).build());
        } else if (editable) {
            category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TranslatableComponent("drg_flares.settings.server_desc")).build());
        } else {
            category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TranslatableComponent("drg_flares.settings.disabled_by_server")).build());
        }
        ServerSettings serverSettings = editable ? ServerSettings.LOCAL : ServerSettings.CURRENT;
        SettingsScreen.addBoolEntry(category, entryBuilder, serverSettings.regeneratingFlaresEnabled, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.regeneratingFlaresRechargeTime, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.regeneratingFlaresMaxCharges, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.flareEntityLimitPerPlayer, editable);
        SettingsScreen.addBoolEntry(category, entryBuilder, serverSettings.flareRecipesInSurvival, editable);
        category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TextComponent(" ")).build());
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.secondsUntilDimmingOut, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.andThenSecondsUntilFizzlingOut, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.andThenSecondsUntilDespawn, editable);
        category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TextComponent(" ")).build());
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.fullBrightnessLightLevel, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.dimmedLightLevel, editable);
        category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TextComponent(" ")).build());
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.secondsUntilIdlingFlareGetsOptimized, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.lightSourceLifespanTicks, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.lightSourceRefreshDistance, editable);
        SettingsScreen.addIntegerEntry(category, entryBuilder, serverSettings.lightSourceSearchDistance, editable);
        SettingsScreen.addBoolEntry(category, entryBuilder, serverSettings.creativeUnlimitedRegeneratingFlares, editable);
        SettingsScreen.addBoolEntry(category, entryBuilder, serverSettings.serverSideLightSources, editable);
        category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TextComponent(" ")).build());
        SettingsScreen.addFloatEntry(category, entryBuilder, serverSettings.flareGravity, editable);
        SettingsScreen.addFloatEntry(category, entryBuilder, serverSettings.flareThrowSpeed, editable);
        SettingsScreen.addFloatEntry(category, entryBuilder, serverSettings.flareThrowAngle, editable);
        SettingsScreen.addFloatEntry(category, entryBuilder, serverSettings.flareSpeedBounceDivider, editable);
        category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TextComponent(" ")).build());
        try {
            category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TranslatableComponent("controls.title")).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.fillKeybindingField((Component)new TranslatableComponent("drg_flares.keys.throw_flare"), PlayerSettings.INSTANCE.throwFlareKey).build());
            category.addEntry((AbstractConfigListEntry)entryBuilder.fillKeybindingField((Component)new TranslatableComponent("drg_flares.keys.flare_mod_settings"), PlayerSettings.INSTANCE.flareModSettingsKey).build());
        }
        catch (Throwable e) {
            category.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)new TranslatableComponent("drg_flares.settings.keybind_error")).build());
        }
        return builder.build();
    }

    private static void addIntegerEntry(ConfigCategory category, ConfigEntryBuilder entryBuilder, SettingsEntry.Integer settingsEntry, boolean editable) {
        Object entry = settingsEntry.max == Integer.MAX_VALUE ? entryBuilder.startIntField((Component)new TranslatableComponent(settingsEntry.displayText), ((Integer)settingsEntry.value).intValue()).setMin(settingsEntry.min).setDefaultValue(((Integer)settingsEntry.defaultValue).intValue()).setSaveConsumer(it -> {
            settingsEntry.value = it;
        }).setTooltip(new Component[]{new TranslatableComponent(settingsEntry.displayText + ".desc")}).build() : entryBuilder.startIntSlider((Component)new TranslatableComponent(settingsEntry.displayText), ((Integer)settingsEntry.value).intValue(), settingsEntry.min, settingsEntry.max).setDefaultValue(((Integer)settingsEntry.defaultValue).intValue()).setSaveConsumer(it -> {
            settingsEntry.value = it;
        }).setTooltip(new Component[]{new TranslatableComponent(settingsEntry.displayText + ".desc")}).build();
        entry.setEditable(editable);
        category.addEntry((AbstractConfigListEntry)entry);
    }

    private static void addFloatEntry(ConfigCategory category, ConfigEntryBuilder entryBuilder, SettingsEntry.Float settingsEntry, boolean editable) {
        FloatListEntry entry = entryBuilder.startFloatField((Component)new TranslatableComponent(settingsEntry.displayText), ((Float)settingsEntry.value).floatValue()).setMin(settingsEntry.min).setMax(settingsEntry.max).setDefaultValue(((Float)settingsEntry.defaultValue).floatValue()).setSaveConsumer(it -> {
            settingsEntry.value = it;
        }).setTooltip(new Component[]{new TranslatableComponent(settingsEntry.displayToolTip)}).build();
        entry.setEditable(editable);
        category.addEntry((AbstractConfigListEntry)entry);
    }

    private static void addBoolEntry(ConfigCategory category, ConfigEntryBuilder entryBuilder, SettingsEntry.Boolean settingsEntry, boolean editable) {
        BooleanListEntry entry = entryBuilder.startBooleanToggle((Component)new TranslatableComponent(settingsEntry.displayText), ((Boolean)settingsEntry.value).booleanValue()).setDefaultValue(((Boolean)settingsEntry.defaultValue).booleanValue()).setSaveConsumer(it -> {
            settingsEntry.value = it;
        }).setTooltip(new Component[]{new TranslatableComponent(settingsEntry.displayToolTip)}).build();
        entry.setEditable(editable);
        category.addEntry((AbstractConfigListEntry)entry);
    }

    private static void onSave() {
        PlayerSettings.INSTANCE.save();
        if (!DRGFlaresUtil.isOnRemoteServer() || DRGFlareRegistry.getInstance().serverSyncMode != ServerSyncMode.SYNC_WITH_SERVER) {
            ServerSettings.LOCAL.save();
            ServerSettings.CURRENT.loadFromJson(ServerSettings.LOCAL.asJson());
            FlareLightBlock.refreshBlockStates();
            DRGFlareRegistry.getInstance().broadcastSettingsChange();
        }
    }
}

