/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.List;
import me.lizardofoz.drgflares.DRGFlares;
import me.lizardofoz.drgflares.config.SettingsEntry;

public abstract class AbstractSettings {
    private File configFile = null;

    protected AbstractSettings() {
    }

    public void loadFromFile(File file) {
        this.configFile = file;
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                this.loadFromJson((JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class));
                return;
            }
            catch (Throwable e) {
                DRGFlares.LOGGER.error("Failed to read the config file: " + file, e);
            }
        }
        this.save();
    }

    protected abstract List<SettingsEntry<?>> getEntries();

    public JsonObject asJson() {
        JsonObject result = new JsonObject();
        for (SettingsEntry<?> entry : this.getEntries()) {
            result.add(entry.configKey, entry.getValueAsJsonElement().get());
        }
        return result;
    }

    public void loadFromJson(JsonObject jsonObject) {
        for (SettingsEntry<?> entry : this.getEntries()) {
            entry.tryElementAsValue(jsonObject.get(entry.configKey));
        }
    }

    public void save() {
        if (this.configFile == null) {
            return;
        }
        try {
            this.configFile.getParentFile().mkdirs();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.asJson(), (Appendable)writer);
        }
        catch (Throwable e) {
            DRGFlares.LOGGER.error("Failed to write the config file: " + this.configFile, e);
        }
    }
}

