/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.entity;

import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.DRGFlares;
import me.lizardofoz.drgflares.block.FlareLightBlock;
import me.lizardofoz.drgflares.block.FlareLightBlockEntity;
import me.lizardofoz.drgflares.config.PlayerSettings;
import me.lizardofoz.drgflares.config.ServerSettings;
import me.lizardofoz.drgflares.util.DRGFlareLimiter;
import me.lizardofoz.drgflares.util.DRGFlaresUtil;
import me.lizardofoz.drgflares.util.FlareColor;
import me.lizardofoz.drgflares.util.ServerSyncMode;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class FlareEntity
extends ThrowableProjectile {
    public FlareColor color;
    public int lifespan = -1;
    public int bounceCount = 1;
    public float rotation = 0.0f;
    private int idleTicks = 0;
    private float prevPartialTick = 0.0f;
    private BlockPos lightBlockPos = null;
    private BlockPos lastHitBlockPos = null;
    private BlockState lastHitBlockState = null;

    public FlareEntity(Level world, FlareColor color) {
        super(DRGFlareRegistry.getInstance().getFlareEntityType(), world);
        this.color = FlareColor.RandomColorPicker.unwrapRandom(color, false);
    }

    private FlareEntity(LivingEntity owner, FlareColor color) {
        super(DRGFlareRegistry.getInstance().getFlareEntityType(), owner, owner.f_19853_);
        this.color = FlareColor.RandomColorPicker.unwrapRandom(color, false);
    }

    public static FlareEntity throwFlare(@NotNull LivingEntity owner, FlareColor color) {
        float throwAngle = ((Float)ServerSettings.CURRENT.flareThrowAngle.value).floatValue();
        float pitchModifier = Math.min(throwAngle, Math.max(0.0f, owner.m_146909_() + (95.0f - throwAngle)));
        FlareEntity flareEntity = new FlareEntity(owner, color);
        flareEntity.m_20343_(flareEntity.m_20185_(), flareEntity.m_20186_() - 0.5, flareEntity.m_20189_());
        flareEntity.m_37251_((Entity)owner, owner.m_146909_() - pitchModifier, owner.m_146908_(), 0.0f, 0.75f * ((Float)ServerSettings.CURRENT.flareThrowSpeed.value).floatValue(), 1.0f);
        if (!owner.f_19853_.f_46443_) {
            owner.f_19853_.m_7967_((Entity)flareEntity);
        } else {
            int randomNegativeId = flareEntity.m_142049_() - 100000;
            while (owner.f_19853_.m_6815_(randomNegativeId) != null) {
                randomNegativeId = owner.f_19853_.m_5822_().nextInt(1000000) - 2000000;
            }
            flareEntity.m_20234_(randomNegativeId);
            DRGFlaresUtil.addEntityOnClient(owner.f_19853_, (Entity)flareEntity);
        }
        return flareEntity;
    }

    public static FlareEntity make(EntityType<FlareEntity> entityType, Level world) {
        return new FlareEntity(world, FlareColor.RED);
    }

    protected void m_8097_() {
    }

    public CompoundTag m_20240_(CompoundTag tag) {
        super.m_20240_(tag);
        tag.m_128405_("lifespan", this.lifespan);
        tag.m_128376_("color", (short)this.color.id);
        return tag;
    }

    public void m_20258_(CompoundTag tag) {
        super.m_20258_(tag);
        this.lifespan = tag.m_128451_("lifespan");
        this.color = FlareColor.byId(tag.m_128448_("color"));
    }

    public boolean m_6097_() {
        return false;
    }

    protected float m_7139_() {
        return 0.024f * ((Float)ServerSettings.CURRENT.flareGravity.value).floatValue();
    }

    public Packet<?> m_5654_() {
        return DRGFlareRegistry.getInstance().createSpawnFlareEntityPacket(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void frame(float partialTick) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        while (partialTick <= this.prevPartialTick) {
            this.prevPartialTick -= 1.0f;
        }
        float delta = partialTick - this.prevPartialTick;
        this.prevPartialTick = partialTick;
        this.rotation = this.m_20184_().m_82556_() < 0.1 && this.bounceCount > 2 ? 0.0f : (this.rotation += 10.0f * delta / (float)this.bounceCount);
    }

    public boolean isLit() {
        return this.lifespan < ((Integer)ServerSettings.CURRENT.secondsUntilDimmingOut.value + (Integer)ServerSettings.CURRENT.andThenSecondsUntilFizzlingOut.value) * 20;
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        BlockPos hitBlockPos = blockHitResult.m_82425_();
        ++this.bounceCount;
        if (this.f_19853_.f_46443_ && !this.m_20069_()) {
            float pitch = 1.1f + this.f_19853_.f_46441_.nextFloat() * 0.3f;
            float volume = (float)((Integer)PlayerSettings.INSTANCE.flareSoundVolume.value).intValue() / 100.0f;
            float farVolume = volume < 0.25f ? volume * 3.0f : (volume < 0.5f ? volume * 2.0f : volume);
            DRGFlaresUtil.playSoundFromEntityOnClient((Entity)this, DRGFlareRegistry.getInstance().FLARE_BOUNCE_EVENT, SoundSource.MASTER, volume, pitch);
            DRGFlaresUtil.playSoundFromEntityOnClient((Entity)this, DRGFlareRegistry.getInstance().FLARE_BOUNCE_FAR_EVENT, SoundSource.MASTER, farVolume * 3.0f, pitch);
        }
        if (hitBlockPos.equals((Object)this.lastHitBlockPos) && this.m_20184_().m_82556_() < 0.01) {
            this.m_20256_(Vec3.f_82478_);
            this.m_20242_(true);
            return;
        }
        this.lastHitBlockPos = hitBlockPos;
        this.lastHitBlockState = this.f_19853_.m_8055_(hitBlockPos);
        double speedDivider = ((Float)ServerSettings.CURRENT.flareSpeedBounceDivider.value).floatValue();
        Vec3 velocity = this.m_20184_();
        if (blockHitResult.m_82434_() == Direction.EAST || blockHitResult.m_82434_() == Direction.WEST) {
            this.m_20334_(-velocity.f_82479_ / speedDivider, velocity.f_82480_ / speedDivider, velocity.f_82481_ / speedDivider);
        } else if (blockHitResult.m_82434_() == Direction.UP || blockHitResult.m_82434_() == Direction.DOWN) {
            this.m_20334_(velocity.f_82479_ / speedDivider, -velocity.f_82480_ / speedDivider, velocity.f_82481_ / speedDivider);
        } else {
            this.m_20334_(velocity.f_82479_ / speedDivider, velocity.f_82480_ / speedDivider, -velocity.f_82481_ / speedDivider);
        }
    }

    public void m_8119_() {
        int ticksUntilDespawn = (Integer)ServerSettings.CURRENT.secondsUntilDimmingOut.value + (Integer)ServerSettings.CURRENT.andThenSecondsUntilFizzlingOut.value + (Integer)ServerSettings.CURRENT.andThenSecondsUntilDespawn.value;
        if (++this.lifespan == 0 && this.f_19853_.f_46443_) {
            DRGFlaresUtil.playSoundFromEntityOnClient((Entity)this, DRGFlareRegistry.getInstance().FLARE_THROW_EVENT, SoundSource.MASTER, (float)((Integer)PlayerSettings.INSTANCE.flareSoundVolume.value).intValue() / 100.0f, 1.0f);
        }
        if (this.lifespan > ticksUntilDespawn * 20 || this.m_20077_() || this.m_20186_() <= (double)DRGFlaresUtil.getVoidDamageLevel(this.f_19853_)) {
            this.m_6074_();
        }
        if (!this.f_19853_.f_46443_ || DRGFlareRegistry.getInstance().serverSyncMode == ServerSyncMode.CLIENT_ONLY) {
            DRGFlareLimiter.reportFlare(this);
        } else {
            this.frame(0.0f);
        }
        int idleOpt = (Integer)ServerSettings.CURRENT.secondsUntilIdlingFlareGetsOptimized.value * 20;
        this.idleTicks = this.m_20184_().m_82556_() < 0.01 && this.bounceCount > 2 ? ++this.idleTicks : 0;
        if (idleOpt <= 0 || this.idleTicks < idleOpt) {
            super.m_8119_();
        }
        if (this.m_20069_()) {
            this.idleTicks = 0;
            this.bounceCount = 10;
            this.m_5997_(0.0, 0.04, 0.0);
        }
        if (this.idleTicks == 20) {
            this.lightBlockPos = null;
        }
        boolean isInsideWaterBlock = this.f_19853_.m_46801_(this.m_142538_());
        if (this.m_20068_() && (isInsideWaterBlock || !this.m_20075_().equals(this.lastHitBlockState))) {
            this.m_20242_(false);
            this.idleTicks = 0;
        }
        if (this.isLit() && (this.f_19853_.f_46443_ || ((Boolean)ServerSettings.CURRENT.serverSideLightSources.value).booleanValue())) {
            this.spawnLightSource(isInsideWaterBlock);
        }
    }

    private void spawnLightSource(boolean isInWaterBlock) {
        try {
            if (this.lightBlockPos == null) {
                this.lightBlockPos = this.findFreeSpace(this.f_19853_, this.m_142538_(), (Integer)ServerSettings.CURRENT.lightSourceSearchDistance.value);
                if (this.lightBlockPos == null) {
                    return;
                }
                BlockEntity blockEntity = this.f_19853_.m_7702_(this.lightBlockPos);
                if (blockEntity instanceof FlareLightBlockEntity) {
                    ((FlareLightBlockEntity)blockEntity).refresh(isInWaterBlock ? 20 : 0);
                } else if (this.lifespan < (Integer)ServerSettings.CURRENT.secondsUntilDimmingOut.value * 20) {
                    this.f_19853_.m_46597_(this.lightBlockPos, FlareLightBlock.getFullBrightnessBlockState());
                } else {
                    this.f_19853_.m_46597_(this.lightBlockPos, FlareLightBlock.getDimmedOutBlockState());
                }
            } else if (this.checkDistance(this.lightBlockPos, this.m_142538_(), (Integer)ServerSettings.CURRENT.lightSourceRefreshDistance.value)) {
                BlockEntity blockEntity = this.f_19853_.m_7702_(this.lightBlockPos);
                if (blockEntity instanceof FlareLightBlockEntity) {
                    int lightLevel = FlareLightBlock.getLightLevel(this.f_19853_, this.lightBlockPos);
                    if (this.lifespan < (Integer)ServerSettings.CURRENT.secondsUntilDimmingOut.value * 20) {
                        if (lightLevel != (Integer)ServerSettings.CURRENT.fullBrightnessLightLevel.value) {
                            this.f_19853_.m_46597_(this.lightBlockPos, FlareLightBlock.getFullBrightnessBlockState());
                        }
                    } else if (lightLevel != (Integer)ServerSettings.CURRENT.dimmedLightLevel.value) {
                        this.f_19853_.m_46597_(this.lightBlockPos, FlareLightBlock.getDimmedOutBlockState());
                    }
                    ((FlareLightBlockEntity)blockEntity).refresh(isInWaterBlock ? 20 : 0);
                } else {
                    this.lightBlockPos = null;
                }
            } else {
                this.lightBlockPos = null;
            }
        }
        catch (Throwable e) {
            DRGFlares.LOGGER.error("Failed to process a light source block for " + this + " -> " + this.lightBlockPos, e);
        }
    }

    private boolean checkDistance(BlockPos blockPosA, BlockPos blockPosB, int distance) {
        return Math.abs(blockPosA.m_123341_() - blockPosB.m_123341_()) <= distance && Math.abs(blockPosA.m_123342_() - blockPosB.m_123342_()) <= distance && Math.abs(blockPosA.m_123343_() - blockPosB.m_123343_()) <= distance;
    }

    private BlockPos findFreeSpace(Level world, BlockPos blockPos, int maxDistance) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[maxDistance * 2 + 1];
        offsets[0] = 0;
        for (int i = 2; i <= maxDistance * 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.m_142082_(x, y, z);
                    BlockState state = world.m_8055_(offsetPos);
                    if (!state.m_60795_() && !state.m_60734_().equals(DRGFlareRegistry.getInstance().getLightSourceBlockType())) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }
}

