/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.packet;

import java.util.UUID;
import me.lizardofoz.drgflares.DRGFlares;
import me.lizardofoz.drgflares.entity.FlareEntity;
import me.lizardofoz.drgflares.util.FlareColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SpawnFlareEntityS2CPacket {
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("drg_flares", "spawn_flare");
    private int id;
    private UUID uuid;
    private double x;
    private double y;
    private double z;
    private int velocityX;
    private int velocityY;
    private int velocityZ;
    private int lifespan;
    private FlareColor color;
    private int bounceCount;

    public SpawnFlareEntityS2CPacket() {
    }

    public SpawnFlareEntityS2CPacket(int id, UUID uuid, double x, double y, double z, Vec3 velocity, int lifespan, FlareColor color, int bounceCount) {
        this.id = id;
        this.uuid = uuid;
        this.x = x;
        this.y = y;
        this.z = z;
        this.velocityX = (int)(Mth.m_14008_((double)velocity.f_82479_, (double)-3.9, (double)3.9) * 8000.0);
        this.velocityY = (int)(Mth.m_14008_((double)velocity.f_82480_, (double)-3.9, (double)3.9) * 8000.0);
        this.velocityZ = (int)(Mth.m_14008_((double)velocity.f_82481_, (double)-3.9, (double)3.9) * 8000.0);
        this.lifespan = lifespan;
        this.color = color;
        this.bounceCount = bounceCount;
    }

    public SpawnFlareEntityS2CPacket(FlareEntity entity) {
        this(entity.m_142049_(), entity.m_142081_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_20184_(), entity.lifespan, entity.color, entity.bounceCount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnOnClient() {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world == null) {
            return;
        }
        FlareEntity entity = new FlareEntity((Level)world, this.color);
        entity.m_20167_(this.x, this.y, this.z);
        entity.m_6027_(this.x, this.y, this.z);
        entity.m_20234_(this.id);
        entity.m_20084_(this.uuid);
        entity.lifespan = this.lifespan;
        entity.color = this.color;
        entity.bounceCount = this.bounceCount;
        world.m_104627_(this.id, (Entity)entity);
    }

    public void read(FriendlyByteBuf buf) {
        try {
            this.id = buf.m_130242_();
            this.uuid = buf.m_130259_();
            this.x = buf.readDouble();
            this.y = buf.readDouble();
            this.z = buf.readDouble();
            this.velocityX = buf.readShort();
            this.velocityY = buf.readShort();
            this.velocityZ = buf.readShort();
            this.lifespan = buf.readShort();
            this.color = FlareColor.byId(buf.readByte());
            this.bounceCount = buf.readByte();
        }
        catch (Exception e) {
            DRGFlares.LOGGER.error("Failed to read SpawnFlareEntityS2CPacket", (Throwable)e);
        }
    }

    public void write(FriendlyByteBuf buf) {
        try {
            buf.m_130130_(this.id);
            buf.m_130077_(this.uuid);
            buf.writeDouble(this.x);
            buf.writeDouble(this.y);
            buf.writeDouble(this.z);
            buf.writeShort(this.velocityX);
            buf.writeShort(this.velocityY);
            buf.writeShort(this.velocityZ);
            buf.writeShort(this.lifespan);
            buf.writeByte(this.color.id);
            buf.writeByte(this.bounceCount);
        }
        catch (Exception e) {
            DRGFlares.LOGGER.error("Failed to write SpawnFlareEntityS2CPacket", (Throwable)e);
        }
    }
}

