/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.packet;

import java.util.List;
import java.util.function.Supplier;
import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.config.ServerSettings;
import me.lizardofoz.drgflares.util.DRGFlarePlayerAspect;
import me.lizardofoz.drgflares.util.DRGFlaresUtil;
import me.lizardofoz.drgflares.util.FlareColor;
import me.lizardofoz.inventorio.api.InventorioAPI;
import me.lizardofoz.inventorio.player.PlayerInventoryAddon;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ThrowFlareC2SPacketWrapper {
    public final FlareColor color;

    public ThrowFlareC2SPacketWrapper(FlareColor color) {
        this.color = color;
    }

    public ThrowFlareC2SPacketWrapper(FriendlyByteBuf buf) {
        this.color = FlareColor.byId(buf.readByte());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.color.id);
    }

    public void invokeOnServer(Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player == null) {
                return;
            }
            if (((Boolean)ServerSettings.CURRENT.regeneratingFlaresEnabled.value).booleanValue()) {
                DRGFlarePlayerAspect playerAspect = DRGFlarePlayerAspect.get((Player)player);
                if (playerAspect != null) {
                    playerAspect.tryThrowRegeneratingFlare((Player)player, this.color);
                }
            } else {
                PlayerInventoryAddon playerInventoryAddon;
                if (DRGFlaresUtil.tryFlare((Player)player, (List<ItemStack>)player.m_150109_().f_35976_) || DRGFlaresUtil.tryFlare((Player)player, (List<ItemStack>)player.m_150109_().f_35974_)) {
                    return;
                }
                if (DRGFlareRegistry.getInstance().isInventorioLoaded() && (playerInventoryAddon = InventorioAPI.getInventoryAddon((Player)player)) != null && (DRGFlaresUtil.tryFlare((Player)player, playerInventoryAddon.utilityBelt) || DRGFlaresUtil.tryFlare((Player)player, playerInventoryAddon.toolBelt) || DRGFlaresUtil.tryFlare((Player)player, playerInventoryAddon.deepPockets))) {
                    return;
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

