/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.util;

import java.util.HashMap;
import java.util.Map;
import me.lizardofoz.drgflares.config.ServerSettings;
import me.lizardofoz.drgflares.entity.FlareEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class DRGFlareLimiter {
    private static final Map<Player, TrackerInstance> playerMap = new HashMap<Player, TrackerInstance>();

    private DRGFlareLimiter() {
    }

    public static void initOrReset() {
        playerMap.clear();
        playerMap.put(null, new TrackerInstance());
    }

    public static void onPlayerJoin(Player playerEntity) {
        playerMap.put(playerEntity, new TrackerInstance());
    }

    public static void onPlayerLeave(Player playerEntity) {
        playerMap.remove(playerEntity);
    }

    public static void tick() {
        if ((Integer)ServerSettings.CURRENT.flareEntityLimitPerPlayer.value <= 0) {
            return;
        }
        for (TrackerInstance tracker : playerMap.values()) {
            if (tracker.flareEntityCount > (Integer)ServerSettings.CURRENT.flareEntityLimitPerPlayer.value && tracker.oldestFlare != null) {
                tracker.oldestFlare.m_6074_();
            }
            tracker.reset();
        }
    }

    public static void reportFlare(FlareEntity entity) {
        if ((Integer)ServerSettings.CURRENT.flareEntityLimitPerPlayer.value <= 0) {
            return;
        }
        TrackerInstance aspect = null;
        Entity owner = entity.m_37282_();
        if (owner instanceof Player) {
            aspect = playerMap.get(owner);
        }
        if (aspect == null) {
            aspect = playerMap.get(null);
        }
        ++aspect.flareEntityCount;
        if (entity.lifespan > aspect.oldestFlareLifetime) {
            aspect.oldestFlareLifetime = entity.lifespan;
            aspect.oldestFlare = entity;
        }
    }

    private static class TrackerInstance {
        private int flareEntityCount;
        private int oldestFlareLifetime;
        private FlareEntity oldestFlare;

        private TrackerInstance() {
        }

        private void reset() {
            this.flareEntityCount = 0;
            this.oldestFlareLifetime = -1;
            this.oldestFlare = null;
        }
    }
}

