/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.util;

import java.util.HashMap;
import java.util.Map;
import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.config.ServerSettings;
import me.lizardofoz.drgflares.entity.FlareEntity;
import me.lizardofoz.drgflares.util.DRGFlaresUtil;
import me.lizardofoz.drgflares.util.FlareColor;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class DRGFlarePlayerAspect {
    private static final Map<Player, DRGFlarePlayerAspect> playerMap = new HashMap<Player, DRGFlarePlayerAspect>();
    public static final DRGFlarePlayerAspect clientLocal = new DRGFlarePlayerAspect();
    private int flaresLeft;
    private int flareRegenStatus;

    public static void initOrReset() {
        playerMap.clear();
        clientLocal.resetInst();
    }

    public static void onPlayerJoin(Player player) {
        playerMap.put(player, new DRGFlarePlayerAspect());
    }

    public static void onPlayerLeave(Player player) {
        playerMap.remove(player);
    }

    public static DRGFlarePlayerAspect get(Player player) {
        return playerMap.get(player);
    }

    public static void tickAll() {
        for (DRGFlarePlayerAspect value : playerMap.values()) {
            value.tick();
        }
    }

    private DRGFlarePlayerAspect() {
        this.resetInst();
    }

    private void resetInst() {
        this.flaresLeft = (Integer)ServerSettings.CURRENT.regeneratingFlaresMaxCharges.value;
        this.flareRegenStatus = 0;
    }

    public void tick() {
        if (this.flaresLeft < (Integer)ServerSettings.CURRENT.regeneratingFlaresMaxCharges.value) {
            if (this.flareRegenStatus < (Integer)ServerSettings.CURRENT.regeneratingFlaresRechargeTime.value * 20) {
                ++this.flareRegenStatus;
            } else {
                this.flareRegenStatus = 0;
                ++this.flaresLeft;
            }
        } else {
            this.flaresLeft = (Integer)ServerSettings.CURRENT.regeneratingFlaresMaxCharges.value;
        }
    }

    public void reduceFlareCount(Player player) {
        if (!DRGFlaresUtil.hasUnlimitedRegeneratingFlares(player) && ((Boolean)ServerSettings.CURRENT.regeneratingFlaresEnabled.value).booleanValue()) {
            this.flaresLeft = Math.max(0, this.flaresLeft - 1);
        }
    }

    public boolean checkFlareToss(Player player) {
        return this.flaresLeft > 0 || DRGFlaresUtil.hasUnlimitedRegeneratingFlares(player);
    }

    public void tryThrowRegeneratingFlare(Player player, FlareColor color) {
        if (!this.checkFlareToss(player) || DRGFlaresUtil.isRegenFlareOnCooldown(player) || player.m_5833_()) {
            return;
        }
        FlareEntity.throwFlare((LivingEntity)player, color);
        Map<FlareColor, Item> itemTypes = DRGFlareRegistry.getInstance().getFlareItemTypes();
        player.m_36335_().m_41524_(itemTypes.get((Object)FlareColor.RED), 5);
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemTypes.get((Object)color)));
        this.reduceFlareCount(player);
    }

    public int getFlaresLeft() {
        return this.flaresLeft;
    }

    public int getFlareRegenStatus() {
        return this.flareRegenStatus;
    }
}

