/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.DRGFlares;
import me.lizardofoz.drgflares.config.ServerSettings;
import me.lizardofoz.drgflares.entity.FlareEntity;
import me.lizardofoz.drgflares.item.FlareItem;
import me.lizardofoz.drgflares.mixin.RecipeManagerAccessor;
import me.lizardofoz.drgflares.util.FlareColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DRGFlaresUtil {
    private static List<Recipe<?>> flareRecipesCache;

    private DRGFlaresUtil() {
    }

    public static void unlockFlareRecipes(Player player) {
        try {
            if (((Boolean)ServerSettings.CURRENT.flareRecipesInSurvival.value).booleanValue()) {
                if (flareRecipesCache == null) {
                    flareRecipesCache = player.f_19853_.m_142572_().m_129894_().m_44051_().stream().filter(it -> it.m_6423_().m_135827_().equals("drg_flares")).collect(Collectors.toList());
                }
                player.m_7281_(flareRecipesCache);
            }
        }
        catch (Throwable e) {
            DRGFlares.LOGGER.error("Failed to Unlock Flare Recipes for " + player, e);
        }
    }

    public static void setRecipes(RecipeManager recipeManager, Iterable<Recipe<?>> recipes) {
        HashMap map = Maps.newHashMap();
        recipes.forEach(recipe -> {
            Map map2 = map.computeIfAbsent(recipe.m_6671_(), recipeType -> Maps.newHashMap());
            Recipe recipe2 = map2.put(recipe.m_6423_(), recipe);
            if (recipe2 != null) {
                throw new IllegalStateException("Duplicate recipe ignored with ID " + recipe.m_6423_());
            }
        });
        ImmutableMap result = ImmutableMap.copyOf((Map)map);
        ((RecipeManagerAccessor)recipeManager).setRecipes((Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>>)result);
    }

    public static boolean isOnRemoteServer() {
        try {
            return !Minecraft.m_91087_().m_91403_().m_6198_().m_129531_();
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static int getVoidDamageLevel(Level world) {
        return world.m_141937_() - 64;
    }

    public static boolean hasUnlimitedRegeneratingFlares(Player player) {
        return player.m_150110_().f_35937_ && (Boolean)ServerSettings.CURRENT.creativeUnlimitedRegeneratingFlares.value != false || ServerSettings.CURRENT.unlimitedSurvivalFlares();
    }

    public static boolean isRegenFlareOnCooldown(Player player) {
        return player.m_36335_().m_41519_(DRGFlareRegistry.getInstance().getFlareItemTypes().get((Object)FlareColor.RED));
    }

    public static FlareColor getFlareColorFromItem(ItemStack stack) {
        for (Map.Entry<FlareColor, Item> entry : DRGFlareRegistry.getInstance().getFlareItemTypes().entrySet()) {
            if (!stack.m_41720_().equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return FlareColor.RED;
    }

    public static boolean tryFlare(Player player, List<ItemStack> inventorySection) {
        for (ItemStack itemStack : inventorySection) {
            Item item = itemStack.m_41720_();
            if (!(item instanceof FlareItem)) continue;
            if (player.m_36335_().m_41519_(item)) {
                return true;
            }
            FlareEntity.throwFlare((LivingEntity)player, DRGFlaresUtil.getFlareColorFromItem(itemStack));
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            player.m_36335_().m_41524_(item, 5);
            player.m_36246_(Stats.f_12982_.m_12902_((Object)item));
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundFromEntityOnClient(Entity entity, SoundEvent sound, SoundSource category, float volume, float pitch) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)new EntityBoundSoundInstance(sound, category, volume, pitch, entity));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void addEntityOnClient(Level world, Entity entity) {
        ((ClientLevel)world).m_104627_(entity.m_142049_(), entity);
    }
}

