/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares.util;

import java.util.Random;

public enum FlareColor {
    RANDOM(-2, "random"),
    RANDOM_BRIGHT_ONLY(-1, "random_bright_only"),
    WHITE(0, "white"),
    ORANGE(1, "orange"),
    MAGENTA(2, "magenta"),
    LIGHT_BLUE(3, "light_blue"),
    YELLOW(4, "yellow"),
    LIME(5, "lime"),
    PINK(6, "pink"),
    GRAY(7, "gray"),
    LIGHT_GRAY(8, "light_gray"),
    CYAN(9, "cyan"),
    PURPLE(10, "purple"),
    BLUE(11, "blue"),
    BROWN(12, "brown"),
    GREEN(13, "green"),
    RED(14, "red"),
    BLACK(15, "black");

    public static final FlareColor[] colors;
    public static final FlareColor[] brightColors;
    public final int id;
    public final String name;

    public static FlareColor byId(int id) {
        for (FlareColor flareColor : FlareColor.values()) {
            if (flareColor.id != id) continue;
            return flareColor;
        }
        return RED;
    }

    public String toString() {
        return this.name;
    }

    private FlareColor(int id, String name) {
        this.id = id;
        this.name = name;
    }

    static {
        colors = new FlareColor[]{WHITE, ORANGE, MAGENTA, LIGHT_BLUE, YELLOW, LIME, PINK, GRAY, LIGHT_GRAY, CYAN, PURPLE, BLUE, BROWN, GREEN, RED, BLACK};
        brightColors = new FlareColor[]{WHITE, ORANGE, MAGENTA, LIGHT_BLUE, YELLOW, LIME, PINK, CYAN, PURPLE, BLUE, BROWN, GREEN, RED};
    }

    public static class RandomColorPicker {
        private static FlareColor nextRandomColor = colors[new Random().nextInt(colors.length)];

        public static FlareColor unwrapRandom(FlareColor color, boolean reroll) {
            if (color.id >= 0) {
                return color;
            }
            if (!reroll) {
                return nextRandomColor;
            }
            FlareColor prevColor = nextRandomColor;
            while (nextRandomColor == prevColor) {
                if (color == RANDOM_BRIGHT_ONLY) {
                    nextRandomColor = brightColors[new Random().nextInt(brightColors.length)];
                    continue;
                }
                nextRandomColor = colors[new Random().nextInt(colors.length)];
            }
            return prevColor;
        }
    }
}

