/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.duckling.client.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import tech.thatgravyboat.duckling.client.rendering.DuckModel;
import tech.thatgravyboat.duckling.common.entity.DuckEntity;

public class DuckRenderer
extends GeoEntityRenderer<DuckEntity> {
    public DuckRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (AnimatedGeoModel)new DuckModel());
    }

    public void renderEarly(DuckEntity animatable, PoseStack stackIn, float ticks, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float partialTicks) {
        super.renderEarly((LivingEntity)animatable, stackIn, ticks, renderTypeBuffer, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, partialTicks);
        if (animatable.m_6162_()) {
            stackIn.m_85841_(0.5f, 0.5f, 0.5f);
        }
    }

    public void render(@NotNull DuckEntity entity, float entityYaw, float partialTicks, @NotNull PoseStack stack, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, stack, bufferIn, packedLightIn);
        Entity holdingEntity = entity.m_21524_();
        if (holdingEntity != null) {
            this.renderLeash(entity, partialTicks, stack, bufferIn, holdingEntity);
        }
    }

    public ResourceLocation getTextureLocation(DuckEntity entity) {
        return entity.getTexture().texture;
    }

    public RenderType getRenderType(DuckEntity animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        return RenderType.m_110473_((ResourceLocation)textureLocation);
    }

    private <E extends Entity> void renderLeash(DuckEntity mob, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, E entity) {
        int v;
        poseStack.m_85836_();
        Vec3 vec3 = entity.m_7398_(f);
        double d = (double)(Mth.m_14179_((float)f, (float)mob.f_20884_, (float)mob.f_20883_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec32 = mob.m_7939_();
        double e = Math.cos(d) * vec32.f_82481_ + Math.sin(d) * vec32.f_82479_;
        double g = Math.sin(d) * vec32.f_82481_ - Math.cos(d) * vec32.f_82479_;
        double h = Mth.m_14139_((double)f, (double)mob.f_19854_, (double)mob.m_20185_()) + e;
        double i = Mth.m_14139_((double)f, (double)mob.f_19855_, (double)mob.m_20186_()) + vec32.f_82480_;
        double j = Mth.m_14139_((double)f, (double)mob.f_19856_, (double)mob.m_20189_()) + g;
        poseStack.m_85837_(e, vec32.f_82480_, g);
        float k = (float)(vec3.f_82479_ - h);
        float l = (float)(vec3.f_82480_ - i);
        float m = (float)(vec3.f_82481_ - j);
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        float o = Mth.m_14195_((float)(k * k + m * m)) * 0.025f / 2.0f;
        float p = m * o;
        float q = k * o;
        BlockPos blockPos = new BlockPos(mob.m_20299_(f));
        BlockPos blockPos2 = new BlockPos(entity.m_20299_(f));
        int r = this.m_6086_((Entity)mob, blockPos);
        int s = entity.m_6060_() ? 15 : entity.f_19853_.m_45517_(LightLayer.BLOCK, blockPos2);
        int t = mob.f_19853_.m_45517_(LightLayer.SKY, blockPos);
        int u = mob.f_19853_.m_45517_(LightLayer.SKY, blockPos2);
        for (v = 0; v <= 24; ++v) {
            DuckRenderer.addVertexPair(vertexConsumer, matrix4f, k, l, m, r, s, t, u, 0.025f, p, q, v, false);
        }
        for (v = 24; v >= 0; --v) {
            DuckRenderer.addVertexPair(vertexConsumer, matrix4f, k, l, m, r, s, t, u, 0.0f, p, q, v, true);
        }
        poseStack.m_85849_();
    }

    private static void addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float f, float g, float h, int i, int j, int k, int l, float n, float o, float p, int q, boolean bl) {
        float r = (float)q / 24.0f;
        int s = (int)Mth.m_14179_((float)r, (float)i, (float)j);
        int t = (int)Mth.m_14179_((float)r, (float)k, (float)l);
        int u = LightTexture.m_109885_((int)s, (int)t);
        float v = q % 2 == (bl ? 1 : 0) ? 0.7f : 1.0f;
        float w = 0.5f * v;
        float x = 0.4f * v;
        float y = 0.3f * v;
        float z = f * r;
        float aa = g > 0.0f ? g * r * r : g - g * (1.0f - r) * (1.0f - r);
        float ab = h * r;
        vertexConsumer.m_85982_(matrix4f, z - o, aa + n, ab + p).m_85950_(w, x, y, 1.0f).m_85969_(u).m_5752_();
        vertexConsumer.m_85982_(matrix4f, z + o, aa + 0.025f - n, ab - p).m_85950_(w, x, y, 1.0f).m_85969_(u).m_5752_();
    }
}

