/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.registry;

import com.shynieke.geore.block.BuddingGeoreBlock;
import com.shynieke.geore.registry.GeOreRegistry;
import com.shynieke.geore.registry.GeOreTabs;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fmllegacy.RegistryObject;

public class GeOreBlockReg {
    private final String name;
    private RegistryObject<AmethystBlock> block;
    private RegistryObject<BuddingGeoreBlock> budding;
    private RegistryObject<AmethystClusterBlock> cluster;
    private RegistryObject<AmethystClusterBlock> large_bud;
    private RegistryObject<AmethystClusterBlock> medium_bud;
    private RegistryObject<AmethystClusterBlock> small_bud;
    private RegistryObject<Item> shard;

    @Nonnull
    public String getName() {
        return this.name;
    }

    public RegistryObject<AmethystBlock> getBlock() {
        return this.block;
    }

    public RegistryObject<BuddingGeoreBlock> getBudding() {
        return this.budding;
    }

    public RegistryObject<AmethystClusterBlock> getCluster() {
        return this.cluster;
    }

    public RegistryObject<AmethystClusterBlock> getLargeBud() {
        return this.large_bud;
    }

    public RegistryObject<AmethystClusterBlock> getMediumBud() {
        return this.medium_bud;
    }

    public RegistryObject<AmethystClusterBlock> getSmallBud() {
        return this.small_bud;
    }

    public RegistryObject<Item> getShard() {
        return this.shard;
    }

    public GeOreBlockReg(String name, MaterialColor color) {
        this(name, color, () -> new Item(new Item.Properties().m_41491_(GeOreTabs.TAB_GEORE)));
    }

    public GeOreBlockReg(String name, MaterialColor color, Supplier<Item> customShard) {
        this.name = name;
        this.block = GeOreRegistry.BLOCKS.register(name + "_block", () -> new AmethystBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60978_(1.5f).m_60918_(SoundType.f_154654_).m_60999_()));
        GeOreRegistry.ITEMS.register(this.getBlock().getId().m_135815_(), () -> new BlockItem((Block)this.getBlock().get(), new Item.Properties().m_41491_(GeOreTabs.TAB_GEORE)));
        this.large_bud = GeOreRegistry.BLOCKS.register("large_" + name + "_bud", () -> new AmethystClusterBlock(5, 3, BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60955_().m_60977_().m_60918_(SoundType.f_154655_).m_60978_(1.5f).m_60953_(p_152651_ -> 4)));
        GeOreRegistry.ITEMS.register(this.getLargeBud().getId().m_135815_(), () -> new BlockItem((Block)this.getLargeBud().get(), new Item.Properties().m_41491_(GeOreTabs.TAB_GEORE)));
        this.medium_bud = GeOreRegistry.BLOCKS.register("medium_" + name + "_bud", () -> new AmethystClusterBlock(4, 3, BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60955_().m_60977_().m_60918_(SoundType.f_154655_).m_60978_(1.5f).m_60953_(p_152651_ -> 2)));
        GeOreRegistry.ITEMS.register(this.getMediumBud().getId().m_135815_(), () -> new BlockItem((Block)this.getMediumBud().get(), new Item.Properties().m_41491_(GeOreTabs.TAB_GEORE)));
        this.small_bud = GeOreRegistry.BLOCKS.register("small_" + name + "_bud", () -> new AmethystClusterBlock(3, 4, BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60955_().m_60977_().m_60918_(SoundType.f_154655_).m_60978_(1.5f).m_60953_(p_152651_ -> 1)));
        GeOreRegistry.ITEMS.register(this.getSmallBud().getId().m_135815_(), () -> new BlockItem((Block)this.getSmallBud().get(), new Item.Properties().m_41491_(GeOreTabs.TAB_GEORE)));
        this.cluster = GeOreRegistry.BLOCKS.register(name + "_cluster", () -> new AmethystClusterBlock(7, 3, BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60955_().m_60977_().m_60918_(SoundType.f_154655_).m_60978_(1.5f).m_60953_(p_152651_ -> 5)));
        GeOreRegistry.ITEMS.register(this.getCluster().getId().m_135815_(), () -> new BlockItem((Block)this.getCluster().get(), new Item.Properties().m_41491_(GeOreTabs.TAB_GEORE)));
        this.budding = GeOreRegistry.BLOCKS.register("budding_" + name, () -> new BuddingGeoreBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_164531_, (MaterialColor)color).m_60977_().m_60978_(1.5f).m_60918_(SoundType.f_154654_).m_60999_(), (Supplier<? extends AmethystClusterBlock>)this.getSmallBud(), (Supplier<? extends AmethystClusterBlock>)this.getMediumBud(), (Supplier<? extends AmethystClusterBlock>)this.getLargeBud(), (Supplier<? extends AmethystClusterBlock>)this.getCluster()));
        GeOreRegistry.ITEMS.register(this.getBudding().getId().m_135815_(), () -> new BlockItem((Block)this.getBudding().get(), new Item.Properties().m_41491_(GeOreTabs.TAB_GEORE)));
        this.shard = GeOreRegistry.ITEMS.register(name + "_shard", customShard);
    }
}

