/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.config;

import com.shynieke.geore.GeOre;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class GeOreConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        GeOre.LOGGER.debug("Loaded GeOre's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        GeOre.LOGGER.debug("GeOre's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue generateCoalGeore;
        public final ForgeConfigSpec.BooleanValue generateCopperGeore;
        public final ForgeConfigSpec.BooleanValue generateDiamondGeore;
        public final ForgeConfigSpec.BooleanValue generateEmeraldGeore;
        public final ForgeConfigSpec.BooleanValue generateGoldGeore;
        public final ForgeConfigSpec.BooleanValue generateIronGeore;
        public final ForgeConfigSpec.BooleanValue generateLapisGeore;
        public final ForgeConfigSpec.BooleanValue generateQuartzGeore;
        public final ForgeConfigSpec.BooleanValue generateQuartzInNetherGeore;
        public final ForgeConfigSpec.BooleanValue generateRedstoneGeore;
        public final ForgeConfigSpec.IntValue coalGeoreRarity;
        public final ForgeConfigSpec.IntValue copperGeoreRarity;
        public final ForgeConfigSpec.IntValue diamondGeoreRarity;
        public final ForgeConfigSpec.IntValue emeraldGeoreRarity;
        public final ForgeConfigSpec.IntValue goldGeoreRarity;
        public final ForgeConfigSpec.IntValue ironGeoreRarity;
        public final ForgeConfigSpec.IntValue lapisGeoreRarity;
        public final ForgeConfigSpec.IntValue quartzGeoreRarity;
        public final ForgeConfigSpec.IntValue redstoneGeoreRarity;
        public final ForgeConfigSpec.IntValue coalGeoreMinY;
        public final ForgeConfigSpec.IntValue coalGeoreMaxY;
        public final ForgeConfigSpec.IntValue copperGeoreMinY;
        public final ForgeConfigSpec.IntValue copperGeoreMaxY;
        public final ForgeConfigSpec.IntValue diamondGeoreMinY;
        public final ForgeConfigSpec.IntValue diamondGeoreMaxY;
        public final ForgeConfigSpec.IntValue emeraldGeoreMinY;
        public final ForgeConfigSpec.IntValue emeraldGeoreMaxY;
        public final ForgeConfigSpec.IntValue goldGeoreMinY;
        public final ForgeConfigSpec.IntValue goldGeoreMaxY;
        public final ForgeConfigSpec.IntValue ironGeoreMinY;
        public final ForgeConfigSpec.IntValue ironGeoreMaxY;
        public final ForgeConfigSpec.IntValue lapisGeoreMinY;
        public final ForgeConfigSpec.IntValue lapisGeoreMaxY;
        public final ForgeConfigSpec.IntValue quartzGeoreMinY;
        public final ForgeConfigSpec.IntValue quartzGeoreMaxY;
        public final ForgeConfigSpec.IntValue redstoneGeoreMinY;
        public final ForgeConfigSpec.IntValue redstoneGeoreMaxY;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Generation settings").push("Generation");
            this.generateCoalGeore = builder.comment("Generate Coal GeOre [Default: true]").define("generateCoalGeore", true);
            this.coalGeoreMinY = builder.comment("The Min Y level that Coal GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("coalGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.coalGeoreMaxY = builder.comment("The max Y level that Coal GeOre will generate at [Default: 30]").defineInRange("coalGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            this.generateCopperGeore = builder.comment("Generate Copper GeOre [Default: true]").define("generateCopperGeore", true);
            this.copperGeoreMinY = builder.comment("The Min Y level that Copper GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("copperGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.copperGeoreMaxY = builder.comment("The max Y level that Copper GeOre will generate at [Default: 30]").defineInRange("copperGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            this.generateDiamondGeore = builder.comment("Generate Diamond GeOre [Default: true]").define("generateDiamondGeore", true);
            this.diamondGeoreMinY = builder.comment("The Min Y level that Diamond GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("diamondGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.diamondGeoreMaxY = builder.comment("The max Y level that Diamond GeOre will generate at [Default: 30]").defineInRange("diamondGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            this.generateEmeraldGeore = builder.comment("Generate Emerald GeOre [Default: true]").define("generateEmeraldGeore", true);
            this.emeraldGeoreMinY = builder.comment("The Min Y level that Emerald GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("emeraldGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.emeraldGeoreMaxY = builder.comment("The max Y level that Emerald GeOre will generate at [Default: 30]").defineInRange("emeraldGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            this.generateGoldGeore = builder.comment("Generate Gold GeOre [Default: true]").define("generateGoldGeore", true);
            this.goldGeoreMinY = builder.comment("The Min Y level that Gold GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("goldGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.goldGeoreMaxY = builder.comment("The max Y level that Gold GeOre will generate at [Default: 30]").defineInRange("goldGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            this.generateIronGeore = builder.comment("Generate Iron GeOre [Default: true]").define("generateIronGeore", true);
            this.ironGeoreMinY = builder.comment("The Min Y level that Iron GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("ironGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.ironGeoreMaxY = builder.comment("The max Y level that Iron GeOre will generate at [Default: 30]").defineInRange("ironGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            this.generateLapisGeore = builder.comment("Generate Lapis GeOre [Default: true]").define("generateLapisGeore", true);
            this.lapisGeoreMinY = builder.comment("The Min Y level that Lapis GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("lapisGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.lapisGeoreMaxY = builder.comment("The max Y level that Lapis GeOre will generate at [Default: 30]").defineInRange("lapisGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            this.generateQuartzGeore = builder.comment("Generate Quartz GeOre [Default: true]").define("generateQuartzGeore", true);
            this.quartzGeoreMinY = builder.comment("The Min Y level that Quartz GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("quartzGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.quartzGeoreMaxY = builder.comment("The max Y level that Quartz GeOre will generate at [Default: 30]").defineInRange("quartzGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            this.generateQuartzInNetherGeore = builder.comment("Generate Quartz GeOre in the Nether [Default: true]").define("generateQuartzInNetherGeore", true);
            this.generateRedstoneGeore = builder.comment("Generate Redstone GeOre [Default: true]").define("generateRedstoneGeore", true);
            this.redstoneGeoreMinY = builder.comment("The Min Y level that Redstone GeOre will generate at (above minimum world height) [Default: 6]").defineInRange("redstoneGeoreMinY", 6, 0, Integer.MAX_VALUE);
            this.redstoneGeoreMaxY = builder.comment("The max Y level that Redstone GeOre will generate at [Default: 30]").defineInRange("redstoneGeoreMaxY", 30, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.comment("Rarity settings").push("Rarity");
            this.coalGeoreRarity = builder.comment("Coal GeOre Rarity [Default: 60] (The higher the value the rarer)").defineInRange("coalGeoreRarity", 60, 0, Integer.MAX_VALUE);
            this.copperGeoreRarity = builder.comment("Copper GeOre Rarity [Default: 90] (The higher the value the rarer)").defineInRange("copperGeoreRarity", 90, 0, Integer.MAX_VALUE);
            this.diamondGeoreRarity = builder.comment("Diamond GeOre Rarity [Default: 270] (The higher the value the rarer)").defineInRange("diamondGeoreRarity", 330, 0, Integer.MAX_VALUE);
            this.emeraldGeoreRarity = builder.comment("Emerald GeOre Rarity [Default: 300] (The higher the value the rarer)").defineInRange("emeraldGeoreRarity", 420, 0, Integer.MAX_VALUE);
            this.goldGeoreRarity = builder.comment("Gold GeOre Rarity [Default: 180] (The higher the value the rarer)").defineInRange("goldGeoreRarity", 180, 0, Integer.MAX_VALUE);
            this.ironGeoreRarity = builder.comment("Iron GeOre Rarity [Default: 120] (The higher the value the rarer)").defineInRange("ironGeoreRarity", 120, 0, Integer.MAX_VALUE);
            this.lapisGeoreRarity = builder.comment("Lapis GeOre Rarity [Default: 210] (The higher the value the rarer)").defineInRange("lapisGeoreRarity", 210, 0, Integer.MAX_VALUE);
            this.quartzGeoreRarity = builder.comment("Quartz GeOre Rarity [Default: 150] (The higher the value the rarer)").defineInRange("quartzGeoreRarity", 150, 0, Integer.MAX_VALUE);
            this.redstoneGeoreRarity = builder.comment("Redstone GeOre Rarity [Default: 240] (The higher the value the rarer)").defineInRange("redstoneGeoreRarity", 240, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

