/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.shynieke.geore.datagen.builder.CustomSimpleCookingRecipeBuilder;
import com.shynieke.geore.registry.GeOreBlockReg;
import com.shynieke.geore.registry.GeOreRegistry;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AmethystBlock;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.client.model.generators.loaders.SeparatePerspectiveModelBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GeOreDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_123914_((DataProvider)new Loots(generator));
            generator.m_123914_((DataProvider)new Recipes(generator));
            GeoreBlockTags provider = new GeoreBlockTags(generator, helper);
            generator.m_123914_((DataProvider)provider);
            generator.m_123914_((DataProvider)new GeoreItemTags(generator, provider, helper));
        }
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new Language(generator));
            generator.m_123914_((DataProvider)new BlockModels(generator, helper));
            generator.m_123914_((DataProvider)new ItemModels(generator, helper));
            generator.m_123914_((DataProvider)new BlockStates(generator, helper));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(GeOreBlockTables::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        public static class GeOreBlockTables
        extends BlockLoot {
            protected void addTables() {
                this.addGeOreTables(GeOreRegistry.COAL_GEORE);
                this.addGeOreTables(GeOreRegistry.COPPER_GEORE);
                this.addGeOreTables(GeOreRegistry.DIAMOND_GEORE);
                this.addGeOreTables(GeOreRegistry.EMERALD_GEORE);
                this.addGeOreTables(GeOreRegistry.GOLD_GEORE);
                this.addGeOreTables(GeOreRegistry.IRON_GEORE);
                this.addGeOreTables(GeOreRegistry.LAPIS_GEORE);
                this.addGeOreTables(GeOreRegistry.QUARTZ_GEORE);
                this.addGeOreTables(GeOreRegistry.REDSTONE_GEORE);
                this.addGeOreTables(GeOreRegistry.RUBY_GEORE);
                this.addGeOreTables(GeOreRegistry.SAPPHIRE_GEORE);
                this.addGeOreTables(GeOreRegistry.TOPAZ_GEORE);
            }

            protected void addGeOreTables(GeOreBlockReg blockReg) {
                this.m_124288_((Block)blockReg.getBlock().get());
                this.m_124175_((Block)blockReg.getCluster().get(), block -> GeOreBlockTables.m_124168_((Block)block, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)blockReg.getShard().get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_144323_)))).m_7170_((LootPoolEntryContainer.Builder)GeOreBlockTables.m_124131_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)blockReg.getShard().get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)))))));
                this.m_124272_((Block)blockReg.getSmallBud().get());
                this.m_124272_((Block)blockReg.getMediumBud().get());
                this.m_124272_((Block)blockReg.getLargeBud().get());
                this.m_124165_((Block)blockReg.getBudding().get(), GeOreBlockTables.m_124125_());
            }

            protected Iterable<Block> getKnownBlocks() {
                return GeOreRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    public static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator generator) {
            super(generator);
        }

        protected void m_176531_(Consumer<FinishedRecipe> recipeConsumer) {
            this.generateRecipes(GeOreRegistry.COAL_GEORE, recipeConsumer);
            this.generateRecipes(GeOreRegistry.COPPER_GEORE, recipeConsumer);
            this.smeltToOre(GeOreRegistry.COPPER_GEORE, 0.7f, Items.f_151052_, recipeConsumer);
            this.generateRecipes(GeOreRegistry.DIAMOND_GEORE, recipeConsumer);
            this.smeltToOre(GeOreRegistry.DIAMOND_GEORE, 1.0f, Items.f_42415_, recipeConsumer);
            this.generateRecipes(GeOreRegistry.EMERALD_GEORE, recipeConsumer);
            this.smeltToOre(GeOreRegistry.EMERALD_GEORE, 1.0f, Items.f_42616_, recipeConsumer);
            this.generateRecipes(GeOreRegistry.GOLD_GEORE, recipeConsumer);
            this.smeltToOre(GeOreRegistry.GOLD_GEORE, 1.0f, Items.f_42417_, recipeConsumer);
            this.generateRecipes(GeOreRegistry.IRON_GEORE, recipeConsumer);
            this.smeltToOre(GeOreRegistry.IRON_GEORE, 0.7f, Items.f_42416_, recipeConsumer);
            this.generateRecipes(GeOreRegistry.LAPIS_GEORE, recipeConsumer);
            this.smeltToOre(GeOreRegistry.LAPIS_GEORE, 0.2f, Items.f_42534_, recipeConsumer);
            this.generateRecipes(GeOreRegistry.QUARTZ_GEORE, recipeConsumer);
            this.smeltToOre(GeOreRegistry.QUARTZ_GEORE, 0.2f, Items.f_42692_, recipeConsumer);
            this.generateRecipes(GeOreRegistry.REDSTONE_GEORE, recipeConsumer);
            this.smeltToOre(GeOreRegistry.REDSTONE_GEORE, 0.7f, Items.f_42451_, recipeConsumer);
            String gemsID = "gemsandcrystals";
            this.generateRecipes(GeOreRegistry.RUBY_GEORE, recipeConsumer);
            this.optionalSmeltToOre(GeOreRegistry.RUBY_GEORE, 0.7f, this.getModItem(new ResourceLocation(gemsID, "ruby")), gemsID, recipeConsumer);
            this.generateRecipes(GeOreRegistry.SAPPHIRE_GEORE, recipeConsumer);
            this.optionalSmeltToOre(GeOreRegistry.SAPPHIRE_GEORE, 0.7f, this.getModItem(new ResourceLocation(gemsID, "sapphire")), gemsID, recipeConsumer);
            this.generateRecipes(GeOreRegistry.TOPAZ_GEORE, recipeConsumer);
            this.optionalSmeltToOre(GeOreRegistry.TOPAZ_GEORE, 0.7f, this.getModItem(new ResourceLocation(gemsID, "topaz")), gemsID, recipeConsumer);
        }

        public Item getModItem(ResourceLocation itemLocation) {
            for (Item item : ForgeRegistries.ITEMS) {
                if (!item.getRegistryName().equals((Object)itemLocation)) continue;
                return item;
            }
            return null;
        }

        private void generateRecipes(GeOreBlockReg blockReg, Consumer<FinishedRecipe> recipeConsumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)blockReg.getBlock().get())).m_126127_(Character.valueOf('S'), (ItemLike)blockReg.getShard().get()).m_126130_("SS").m_126130_("SS").m_142284_("has_" + blockReg.getName() + "geore_shard", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)blockReg.getShard().get()))).m_176498_(recipeConsumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)blockReg.getSpyglass().get())).m_126127_(Character.valueOf('#'), (ItemLike)blockReg.getShard().get()).m_126127_(Character.valueOf('X'), (ItemLike)Items.f_151052_).m_126130_(" # ").m_126130_(" X ").m_126130_(" X ").m_142284_("has_" + blockReg.getName() + "geore_shard", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)blockReg.getShard().get()))).m_176498_(recipeConsumer);
        }

        private void smeltToOre(GeOreBlockReg blockReg, float xp, Item item, Consumer<FinishedRecipe> recipeConsumer) {
            SimpleCookingRecipeBuilder.m_126272_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (ItemLike)item, (float)xp, (int)200).m_142409_("geore").m_142284_("has_" + blockReg.getName() + "geore_shard", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)blockReg.getShard().get()))).m_142700_(recipeConsumer, new ResourceLocation("geore", item.getRegistryName().m_135815_() + "_from_smelting_" + blockReg.getShard().getId().m_135815_()));
            SimpleCookingRecipeBuilder.m_126267_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (ItemLike)item, (float)xp, (int)100).m_142409_("geore").m_142284_("has_" + blockReg.getName() + "geore_shard", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)blockReg.getShard().get()))).m_142700_(recipeConsumer, new ResourceLocation("geore", item.getRegistryName().m_135815_() + "_from_blasting_" + blockReg.getShard().getId().m_135815_()));
        }

        private void optionalSmeltToOre(GeOreBlockReg blockReg, float xp, Item item, String modid, Consumer<FinishedRecipe> recipeConsumer) {
            new ConditionalRecipe.Builder().addCondition((ICondition)new ModLoadedCondition(modid)).addRecipe(arg_0 -> ((CustomSimpleCookingRecipeBuilder)CustomSimpleCookingRecipeBuilder.smelting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (ItemLike)item, xp, 200).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)blockReg.getShard().get())))).m_176498_(arg_0)).build(recipeConsumer, new ResourceLocation("geore", item.getRegistryName().m_135815_() + "_from_smelting_" + blockReg.getShard().getId().m_135815_()));
            new ConditionalRecipe.Builder().addCondition((ICondition)new ModLoadedCondition(modid)).addRecipe(arg_0 -> ((CustomSimpleCookingRecipeBuilder)CustomSimpleCookingRecipeBuilder.blasting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)blockReg.getShard().get()}), (ItemLike)item, xp, 100).group("geore").unlockedBy("has_" + blockReg.getName() + "geore_shard", (CriterionTriggerInstance)Recipes.m_125977_((ItemLike)((ItemLike)blockReg.getShard().get())))).m_176498_(arg_0)).build(recipeConsumer, new ResourceLocation("geore", item.getRegistryName().m_135815_() + "_from_blasting_" + blockReg.getShard().getId().m_135815_()));
        }
    }

    public static class GeoreBlockTags
    extends BlockTagsProvider {
        public static final TagKey<Block> RELOCATION_NOT_SUPPORTED = GeoreBlockTags.forgeTag("relocation_not_supported");
        public static final TagKey<Block> NON_MOVABLE = GeoreBlockTags.modTag("create", "non_movable");

        public GeoreBlockTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "geore", existingFileHelper);
        }

        private static TagKey<Block> forgeTag(String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }

        private static TagKey<Block> modTag(String modid, String name) {
            return BlockTags.create((ResourceLocation)new ResourceLocation(modid, name));
        }

        protected void m_6577_() {
            this.m_206424_(RELOCATION_NOT_SUPPORTED).m_126582_((Object)((Block)GeOreRegistry.COAL_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.COPPER_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.DIAMOND_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.EMERALD_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.GOLD_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.IRON_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.LAPIS_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.QUARTZ_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.REDSTONE_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.RUBY_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.SAPPHIRE_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.TOPAZ_GEORE.getBudding().get()));
            this.m_206424_(NON_MOVABLE).m_126582_((Object)((Block)GeOreRegistry.COAL_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.COPPER_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.DIAMOND_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.EMERALD_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.GOLD_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.IRON_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.LAPIS_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.QUARTZ_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.REDSTONE_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.RUBY_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.SAPPHIRE_GEORE.getBudding().get())).m_126582_((Object)((Block)GeOreRegistry.TOPAZ_GEORE.getBudding().get()));
            this.addMineable(GeOreRegistry.COAL_GEORE);
            this.addMineable(GeOreRegistry.COPPER_GEORE);
            this.addMineable(GeOreRegistry.DIAMOND_GEORE);
            this.addMineable(GeOreRegistry.EMERALD_GEORE);
            this.addMineable(GeOreRegistry.GOLD_GEORE);
            this.addMineable(GeOreRegistry.IRON_GEORE);
            this.addMineable(GeOreRegistry.LAPIS_GEORE);
            this.addMineable(GeOreRegistry.QUARTZ_GEORE);
            this.addMineable(GeOreRegistry.REDSTONE_GEORE);
            this.addMineable(GeOreRegistry.RUBY_GEORE);
            this.addMineable(GeOreRegistry.SAPPHIRE_GEORE);
            this.addMineable(GeOreRegistry.TOPAZ_GEORE);
            this.addCrystalSounds(GeOreRegistry.COAL_GEORE);
            this.addCrystalSounds(GeOreRegistry.COPPER_GEORE);
            this.addCrystalSounds(GeOreRegistry.DIAMOND_GEORE);
            this.addCrystalSounds(GeOreRegistry.EMERALD_GEORE);
            this.addCrystalSounds(GeOreRegistry.GOLD_GEORE);
            this.addCrystalSounds(GeOreRegistry.IRON_GEORE);
            this.addCrystalSounds(GeOreRegistry.LAPIS_GEORE);
            this.addCrystalSounds(GeOreRegistry.QUARTZ_GEORE);
            this.addCrystalSounds(GeOreRegistry.REDSTONE_GEORE);
            this.addCrystalSounds(GeOreRegistry.RUBY_GEORE);
            this.addCrystalSounds(GeOreRegistry.SAPPHIRE_GEORE);
            this.addCrystalSounds(GeOreRegistry.TOPAZ_GEORE);
            this.addStorage(GeOreRegistry.COAL_GEORE);
            this.addStorage(GeOreRegistry.COPPER_GEORE);
            this.addStorage(GeOreRegistry.DIAMOND_GEORE);
            this.addStorage(GeOreRegistry.EMERALD_GEORE);
            this.addStorage(GeOreRegistry.GOLD_GEORE);
            this.addStorage(GeOreRegistry.IRON_GEORE);
            this.addStorage(GeOreRegistry.LAPIS_GEORE);
            this.addStorage(GeOreRegistry.QUARTZ_GEORE);
            this.addStorage(GeOreRegistry.REDSTONE_GEORE);
            this.addStorage(GeOreRegistry.RUBY_GEORE);
            this.addStorage(GeOreRegistry.SAPPHIRE_GEORE);
            this.addStorage(GeOreRegistry.TOPAZ_GEORE);
        }

        private void addMineable(GeOreBlockReg blockReg) {
            this.m_206424_(BlockTags.f_144282_).m_126582_((Object)((Block)blockReg.getCluster().get())).m_126582_((Object)((Block)blockReg.getSmallBud().get())).m_126582_((Object)((Block)blockReg.getMediumBud().get())).m_126582_((Object)((Block)blockReg.getLargeBud().get())).m_126582_((Object)((Block)blockReg.getBlock().get())).m_126582_((Object)((Block)blockReg.getBudding().get()));
        }

        private void addCrystalSounds(GeOreBlockReg blockReg) {
            this.m_206424_(BlockTags.f_144270_).m_126582_((Object)((Block)blockReg.getBlock().get())).m_126582_((Object)((Block)blockReg.getBudding().get()));
        }

        private void addStorage(GeOreBlockReg blockReg) {
            this.m_206424_(Tags.Blocks.STORAGE_BLOCKS_AMETHYST).m_126582_((Object)((Block)blockReg.getBlock().get()));
        }
    }

    public static class GeoreItemTags
    extends ItemTagsProvider {
        public static final TagKey<Item> GEORE_CLUSTERS = GeoreItemTags.forgeTag("geore_clusters");
        public static final TagKey<Item> GEORE_SMALL_BUDS = GeoreItemTags.forgeTag("geore_small_buds");
        public static final TagKey<Item> GEORE_MEDIUM_BUDS = GeoreItemTags.forgeTag("geore_medium_buds");
        public static final TagKey<Item> GEORE_LARGE_BUDS = GeoreItemTags.forgeTag("geore_large_buds");
        public static final TagKey<Item> GEORE_SHARDS = GeoreItemTags.forgeTag("geore_shards");
        public static final TagKey<Item> GEORE_BLOCKS = GeoreItemTags.forgeTag("geore_blocks");

        public GeoreItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagsProvider, ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagsProvider, "geore", existingFileHelper);
        }

        protected void m_6577_() {
            this.addGeore(GeOreRegistry.COAL_GEORE);
            this.addGeore(GeOreRegistry.COPPER_GEORE);
            this.addGeore(GeOreRegistry.DIAMOND_GEORE);
            this.addGeore(GeOreRegistry.EMERALD_GEORE);
            this.addGeore(GeOreRegistry.GOLD_GEORE);
            this.addGeore(GeOreRegistry.IRON_GEORE);
            this.addGeore(GeOreRegistry.LAPIS_GEORE);
            this.addGeore(GeOreRegistry.QUARTZ_GEORE);
            this.addGeore(GeOreRegistry.REDSTONE_GEORE);
            this.addGeore(GeOreRegistry.RUBY_GEORE);
            this.addGeore(GeOreRegistry.SAPPHIRE_GEORE);
            this.addGeore(GeOreRegistry.TOPAZ_GEORE);
            this.addStorage(GeOreRegistry.COAL_GEORE);
            this.addStorage(GeOreRegistry.COPPER_GEORE);
            this.addStorage(GeOreRegistry.DIAMOND_GEORE);
            this.addStorage(GeOreRegistry.EMERALD_GEORE);
            this.addStorage(GeOreRegistry.GOLD_GEORE);
            this.addStorage(GeOreRegistry.IRON_GEORE);
            this.addStorage(GeOreRegistry.LAPIS_GEORE);
            this.addStorage(GeOreRegistry.QUARTZ_GEORE);
            this.addStorage(GeOreRegistry.REDSTONE_GEORE);
            this.addStorage(GeOreRegistry.RUBY_GEORE);
            this.addStorage(GeOreRegistry.SAPPHIRE_GEORE);
            this.addStorage(GeOreRegistry.TOPAZ_GEORE);
        }

        private void addStorage(GeOreBlockReg blockReg) {
            this.m_206424_(Tags.Items.STORAGE_BLOCKS_AMETHYST).m_126582_((Object)((AmethystBlock)blockReg.getBlock().get()).m_5456_());
        }

        private void addGeore(GeOreBlockReg blockReg) {
            TagKey<Item> smallBudsTag = GeoreItemTags.forgeTag("geore_small_buds/" + blockReg.getName());
            this.m_206424_(GEORE_SMALL_BUDS).m_206428_(smallBudsTag);
            this.m_206424_(smallBudsTag).m_126582_((Object)((AmethystClusterBlock)blockReg.getCluster().get()).m_5456_());
            TagKey<Item> mediumBudsTag = GeoreItemTags.forgeTag("geore_medium_buds/" + blockReg.getName());
            this.m_206424_(GEORE_MEDIUM_BUDS).m_206428_(mediumBudsTag);
            this.m_206424_(mediumBudsTag).m_126582_((Object)((AmethystClusterBlock)blockReg.getSmallBud().get()).m_5456_());
            TagKey<Item> largeBudsTag = GeoreItemTags.forgeTag("geore_large_buds/" + blockReg.getName());
            this.m_206424_(GEORE_LARGE_BUDS).m_206428_(largeBudsTag);
            this.m_206424_(largeBudsTag).m_126582_((Object)((AmethystClusterBlock)blockReg.getCluster().get()).m_5456_());
            TagKey<Item> clusterTag = GeoreItemTags.forgeTag("geore_clusters/" + blockReg.getName());
            this.m_206424_(GEORE_CLUSTERS).m_206428_(clusterTag);
            this.m_206424_(clusterTag).m_126582_((Object)((AmethystClusterBlock)blockReg.getCluster().get()).m_5456_());
            TagKey<Item> shardTag = GeoreItemTags.forgeTag("geore_shards/" + blockReg.getName());
            this.m_206424_(GEORE_SHARDS).m_206428_(shardTag);
            this.m_206424_(shardTag).m_126582_((Object)((Item)blockReg.getShard().get()));
            TagKey<Item> blockTag = GeoreItemTags.forgeTag("geore_blocks/" + blockReg.getName());
            this.m_206424_(GEORE_BLOCKS).m_206428_(blockTag);
            this.m_206424_(blockTag).m_126582_((Object)((AmethystBlock)blockReg.getBlock().get()).m_5456_());
        }

        private static TagKey<Item> forgeTag(String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }
    }

    private static class Language
    extends LanguageProvider {
        public Language(DataGenerator gen) {
            super(gen, "geore", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.geore", "GeOre");
            this.generateLang("Coal", GeOreRegistry.COAL_GEORE);
            this.generateLang("Copper", GeOreRegistry.COPPER_GEORE);
            this.generateLang("Diamond", GeOreRegistry.DIAMOND_GEORE);
            this.generateLang("Emerald", GeOreRegistry.EMERALD_GEORE);
            this.generateLang("Gold", GeOreRegistry.GOLD_GEORE);
            this.generateLang("Iron", GeOreRegistry.IRON_GEORE);
            this.generateLang("Lapis", GeOreRegistry.LAPIS_GEORE);
            this.generateLang("Quartz", GeOreRegistry.QUARTZ_GEORE);
            this.generateLang("Redstone", GeOreRegistry.REDSTONE_GEORE);
            this.generateLang("Ruby", GeOreRegistry.RUBY_GEORE);
            this.generateLang("Sapphire", GeOreRegistry.SAPPHIRE_GEORE);
            this.generateLang("Topaz", GeOreRegistry.TOPAZ_GEORE);
        }

        public void generateLang(String name, GeOreBlockReg blockReg) {
            this.addBlock((Supplier)blockReg.getBlock(), "Block Of " + name + " Geore");
            this.addBlock((Supplier)blockReg.getBudding(), "Budding " + name + " Geore");
            this.addBlock((Supplier)blockReg.getSmallBud(), "Small " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getMediumBud(), "Medium " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getLargeBud(), "Large " + name + " Geore Bud");
            this.addBlock((Supplier)blockReg.getCluster(), name + " Geore Cluster");
            this.addItem((Supplier)blockReg.getShard(), name + " Geore Shard");
            this.addItem((Supplier)blockReg.getSpyglass(), name + " Geore Spyglass");
        }
    }

    private static class BlockModels
    extends BlockModelProvider {
        public BlockModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "geore", helper);
        }

        protected void registerModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.cubeAll(blockReg.getBlock().getId().m_135815_(), this.modLoc("block/" + blockReg.getBlock().getId().m_135815_()));
            this.cubeAll(blockReg.getBudding().getId().m_135815_(), this.modLoc("block/" + blockReg.getBudding().getId().m_135815_()));
            this.crossBlock((Block)blockReg.getCluster().get());
            this.crossBlock((Block)blockReg.getSmallBud().get());
            this.crossBlock((Block)blockReg.getMediumBud().get());
            this.crossBlock((Block)blockReg.getLargeBud().get());
        }

        private void crossBlock(Block block) {
            String path = block.getRegistryName().m_135815_();
            this.cross(path, this.modLoc("block/" + path));
        }
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "geore", helper);
        }

        protected void registerModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.singleTexture(blockReg.getShard().getId().m_135815_(), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("geore", "item/" + blockReg.getShard().getId().m_135815_()));
            this.withExistingParent(blockReg.getBlock().getId().m_135815_(), new ResourceLocation("geore", "block/" + blockReg.getBlock().getId().m_135815_()));
            this.withExistingParent(blockReg.getBudding().getId().m_135815_(), new ResourceLocation("geore", "block/" + blockReg.getBudding().getId().m_135815_()));
            this.makeCluster((Block)blockReg.getCluster().get());
            this.makeSmallBud((Block)blockReg.getSmallBud().get());
            this.makeMediumBud((Block)blockReg.getMediumBud().get());
            this.makeLargeBud((Block)blockReg.getLargeBud().get());
            this.makeSpyglass(blockReg.getSpyglass());
        }

        private void makeSpyglass(RegistryObject<Item> spyglass) {
            String path = spyglass.getId().m_135815_();
            ModelBuilder spyglass_gui = ((ItemModelBuilder)this.withExistingParent(path + "_gui", this.mcLoc("spyglass"))).texture("layer0", this.modLoc("item/" + path));
            ModelBuilder spyglass_hand = ((ItemModelBuilder)this.withExistingParent(path + "_in_hand", this.mcLoc("spyglass_in_hand"))).texture("spyglass", this.modLoc("item/" + path + "_model"));
            ((SeparatePerspectiveModelBuilder)((ItemModelBuilder)this.withExistingParent(path, "forge:item/default")).customLoader(SeparatePerspectiveModelBuilder::begin)).base((ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_hand))).perspective(ItemTransforms.TransformType.GUI, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).perspective(ItemTransforms.TransformType.GROUND, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).perspective(ItemTransforms.TransformType.FIXED, (ModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.nested()).parent((ModelFile)spyglass_gui))).end();
        }

        private void makeCluster(Block block) {
            String path = block.getRegistryName().m_135815_();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/generated")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ModelBuilder.Perspective.HEAD).translation(0.0f, 14.0f, -5.0f).end();
        }

        private void makeSmallBud(Block block) {
            String path = block.getRegistryName().m_135815_();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ModelBuilder.Perspective.FIRSTPERSON_RIGHT).rotation(0.0f, -90.0f, 25.0f).translation(0.0f, 6.0f, 0.0f).scale(0.68f, 0.68f, 0.68f).end().transform(ModelBuilder.Perspective.FIXED).translation(0.0f, 7.0f, 0.0f).end();
        }

        private void makeMediumBud(Block block) {
            String path = block.getRegistryName().m_135815_();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ModelBuilder.Perspective.FIXED).translation(0.0f, 6.0f, 0.0f).end();
        }

        private void makeLargeBud(Block block) {
            String path = block.getRegistryName().m_135815_();
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(path)).parent((ModelFile)new ModelFile.UncheckedModelFile(this.mcLoc("item/amethyst_bud")))).texture("layer0", this.modLoc("block/" + path))).transforms().transform(ModelBuilder.Perspective.FIXED).translation(0.0f, 4.0f, 0.0f).end();
        }
    }

    private static class BlockStates
    extends BlockStateProvider {
        public BlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "geore", helper);
        }

        protected void registerStatesAndModels() {
            this.generateGeoreModels(GeOreRegistry.COAL_GEORE);
            this.generateGeoreModels(GeOreRegistry.COPPER_GEORE);
            this.generateGeoreModels(GeOreRegistry.DIAMOND_GEORE);
            this.generateGeoreModels(GeOreRegistry.EMERALD_GEORE);
            this.generateGeoreModels(GeOreRegistry.GOLD_GEORE);
            this.generateGeoreModels(GeOreRegistry.IRON_GEORE);
            this.generateGeoreModels(GeOreRegistry.LAPIS_GEORE);
            this.generateGeoreModels(GeOreRegistry.QUARTZ_GEORE);
            this.generateGeoreModels(GeOreRegistry.REDSTONE_GEORE);
            this.generateGeoreModels(GeOreRegistry.RUBY_GEORE);
            this.generateGeoreModels(GeOreRegistry.SAPPHIRE_GEORE);
            this.generateGeoreModels(GeOreRegistry.TOPAZ_GEORE);
        }

        protected void generateGeoreModels(GeOreBlockReg blockReg) {
            this.simpleBlock((Block)blockReg.getBlock().get());
            this.simpleBlock((Block)blockReg.getBudding().get());
            this.clusterBlock((Block)blockReg.getCluster().get());
            this.clusterBlock((Block)blockReg.getLargeBud().get());
            this.clusterBlock((Block)blockReg.getMediumBud().get());
            this.clusterBlock((Block)blockReg.getSmallBud().get());
        }

        private void clusterBlock(Block block) {
            ModelFile.ExistingModelFile clusterBlock = this.models().getExistingFile(this.modLoc("block/" + block.getRegistryName().m_135815_()));
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)clusterBlock).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)clusterBlock).addModel()).partialState().with((Property)BlockStateProperties.f_61372_, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)clusterBlock).rotationX(90).rotationY(270).addModel();
        }
    }
}

