/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.geore.datagen.builder;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Registry;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCookingSerializer;
import net.minecraft.world.level.ItemLike;

public class CustomSimpleCookingRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient ingredient;
    private final float experience;
    private final int cookingTime;
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final SimpleCookingSerializer<?> serializer;

    private CustomSimpleCookingRecipeBuilder(ItemLike result, Ingredient ingredient, float xp, int time, SimpleCookingSerializer<?> serializer) {
        this.result = result.m_5456_();
        this.ingredient = ingredient;
        this.experience = xp;
        this.cookingTime = time;
        this.serializer = serializer;
    }

    public static CustomSimpleCookingRecipeBuilder cooking(Ingredient ingredient, ItemLike result, float xp, int time, SimpleCookingSerializer<?> serializer) {
        return new CustomSimpleCookingRecipeBuilder(result, ingredient, xp, time, serializer);
    }

    public static CustomSimpleCookingRecipeBuilder campfireCooking(Ingredient ingredient, ItemLike result, float xp, int time) {
        return CustomSimpleCookingRecipeBuilder.cooking(ingredient, result, xp, time, RecipeSerializer.f_44094_);
    }

    public static CustomSimpleCookingRecipeBuilder blasting(Ingredient ingredient, ItemLike result, float xp, int time) {
        return CustomSimpleCookingRecipeBuilder.cooking(ingredient, result, xp, time, RecipeSerializer.f_44092_);
    }

    public static CustomSimpleCookingRecipeBuilder smelting(Ingredient ingredient, ItemLike result, float xp, int time) {
        return CustomSimpleCookingRecipeBuilder.cooking(ingredient, result, xp, time, RecipeSerializer.f_44091_);
    }

    public static CustomSimpleCookingRecipeBuilder smoking(Ingredient ingredient, ItemLike result, float xp, int time) {
        return CustomSimpleCookingRecipeBuilder.cooking(ingredient, result, xp, time, RecipeSerializer.f_44093_);
    }

    public CustomSimpleCookingRecipeBuilder unlockedBy(String triggerName, CriterionTriggerInstance triggerInstance) {
        this.advancement.m_138386_(triggerName, triggerInstance);
        return this;
    }

    public CustomSimpleCookingRecipeBuilder group(@Nullable String group) {
        this.group = group;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_142700_(Consumer<FinishedRecipe> recipeConsumer, ResourceLocation p_126264_) {
        this.ensureValid(p_126264_);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)p_126264_)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)p_126264_)).m_138360_(RequirementsStrategy.f_15979_);
        recipeConsumer.accept(new Result(p_126264_, this.group == null ? "" : this.group, this.ingredient, this.result, this.experience, this.cookingTime, this.advancement, new ResourceLocation(p_126264_.m_135827_(), "recipes/" + p_126264_.m_135815_()), (RecipeSerializer<? extends AbstractCookingRecipe>)this.serializer));
    }

    private void ensureValid(ResourceLocation p_126266_) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + p_126266_);
        }
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Ingredient ingredient;
        private final Item result;
        private final float experience;
        private final int cookingTime;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final RecipeSerializer<? extends AbstractCookingRecipe> serializer;

        public Result(ResourceLocation id, String group, Ingredient ingredient, Item result, float xp, int time, Advancement.Builder advancement, ResourceLocation advancementID, RecipeSerializer<? extends AbstractCookingRecipe> serializer) {
            this.id = id;
            this.group = group;
            this.ingredient = ingredient;
            this.result = result;
            this.experience = xp;
            this.cookingTime = time;
            this.advancement = advancement;
            this.advancementId = advancementID;
            this.serializer = serializer;
        }

        public void m_7917_(JsonObject jsonObject) {
            if (!this.group.isEmpty()) {
                jsonObject.addProperty("group", this.group);
            }
            jsonObject.add("ingredient", this.ingredient.m_43942_());
            jsonObject.addProperty("result", Registry.f_122827_.m_7981_((Object)this.result).toString());
            jsonObject.addProperty("experience", (Number)Float.valueOf(this.experience));
            jsonObject.addProperty("cookingtime", (Number)this.cookingTime);
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

