/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.setup.capabilities;

import com.minecraftserverzone.harrypotter.setup.capabilities.DefaultPlayerStats;
import com.minecraftserverzone.harrypotter.setup.capabilities.IPlayerStats;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerStatsProvider
implements ICapabilitySerializable<CompoundTag> {
    private final DefaultPlayerStats stats = new DefaultPlayerStats();
    private final LazyOptional<IPlayerStats> statsOptional = LazyOptional.of(() -> this.stats);
    public static Capability<IPlayerStats> PLAYER_STATS_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerStats>(){});

    public void invalidate() {
        this.statsOptional.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return PLAYER_STATS_CAPABILITY.orEmpty(cap, this.statsOptional);
    }

    public CompoundTag serializeNBT() {
        if (PLAYER_STATS_CAPABILITY == null) {
            return new CompoundTag();
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("battletick", this.stats.getBattleTick());
        tag.m_128405_("flying", this.stats.getFlying());
        tag.m_128405_("clickedskill", this.stats.getClickedSkill());
        tag.m_128405_("selectedhotbar", this.stats.getSelectedHotbar());
        tag.m_128405_("hotbarbeforebattlestance", this.stats.getHotbarBeforeBattleStance());
        tag.m_128405_("usingskill", this.stats.getUsingSkill());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (PLAYER_STATS_CAPABILITY != null) {
            this.stats.setBattleTick(nbt.m_128451_("battletick"));
            this.stats.setFlying(nbt.m_128451_("flying"));
            this.stats.setClickedSkill(nbt.m_128451_("clickedskill"));
            this.stats.setSelectedHotbar(nbt.m_128451_("selectedhotbar"));
            this.stats.setHotbarBeforeBattleStance(nbt.m_128451_("hotbarbeforebattlestance"));
            this.stats.setUsingSkill(nbt.m_128451_("usingskill"));
        }
    }
}

