/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.mobs.dementor;

import com.minecraftserverzone.harrypotter.mobs.death_eater.DeathEater;
import com.minecraftserverzone.harrypotter.mobs.inferius.Inferius;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class Dementor
extends Monster {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Dementor.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    @Nullable
    private BlockPos boundOrigin;

    public Dementor(EntityType<? extends Dementor> p_33984_, Level p_33985_) {
        super(p_33984_, p_33985_);
        this.f_21342_ = new VexMoveControl(this);
        this.f_21364_ = 10;
    }

    public void m_6478_(MoverType p_33997_, Vec3 p_33998_) {
        super.m_6478_(p_33997_, p_33998_);
        this.m_20101_();
    }

    protected boolean m_6149_() {
        return true;
    }

    protected boolean m_8028_() {
        return true;
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_5825_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        this.f_19794_ = true;
        super.m_8119_();
        this.f_19794_ = false;
        this.m_20242_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new VexChargeAttackGoal());
        this.f_21345_.m_25352_(8, (Goal)new VexRandomMoveGoal());
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Dementor.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, DeathEater.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Inferius.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 100.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void m_7378_(CompoundTag p_34008_) {
        super.m_7378_(p_34008_);
        if (p_34008_.m_128441_("BoundX")) {
            this.boundOrigin = new BlockPos(p_34008_.m_128451_("BoundX"), p_34008_.m_128451_("BoundY"), p_34008_.m_128451_("BoundZ"));
        }
    }

    public void m_7380_(CompoundTag p_34015_) {
        super.m_7380_(p_34015_);
        if (this.boundOrigin != null) {
            p_34015_.m_128405_("BoundX", this.boundOrigin.m_123341_());
            p_34015_.m_128405_("BoundY", this.boundOrigin.m_123342_());
            p_34015_.m_128405_("BoundZ", this.boundOrigin.m_123343_());
        }
    }

    @Nullable
    public BlockPos getBoundOrigin() {
        return this.boundOrigin;
    }

    public void setBoundOrigin(@Nullable BlockPos p_34034_) {
        this.boundOrigin = p_34034_;
    }

    private boolean getVexFlag(int p_34011_) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & p_34011_) != 0;
    }

    private void setVexFlag(int p_33990_, boolean p_33991_) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = p_33991_ ? (i |= p_33990_) : (i &= ~p_33990_);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getVexFlag(1);
    }

    public void setIsCharging(boolean p_34043_) {
        this.setVexFlag(1, p_34043_);
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12501_;
    }

    public float m_6073_() {
        return 1.0f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34002_, DifficultyInstance p_34003_, MobSpawnType p_34004_, @Nullable SpawnGroupData p_34005_, @Nullable CompoundTag p_34006_) {
        this.m_6851_(p_34003_);
        this.m_6850_(p_34003_);
        return super.m_6518_(p_34002_, p_34003_, p_34004_, p_34005_, p_34006_);
    }

    class VexMoveControl
    extends MoveControl {
        public VexMoveControl(Dementor p_34062_) {
            super((Mob)p_34062_);
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3 = new Vec3(this.f_24975_ - Dementor.this.m_20185_(), this.f_24976_ - Dementor.this.m_20186_(), this.f_24977_ - Dementor.this.m_20189_());
                double d0 = vec3.m_82553_();
                if (d0 < Dementor.this.m_142469_().m_82309_()) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    Dementor.this.m_20256_(Dementor.this.m_20184_().m_82490_(0.5));
                } else {
                    Dementor.this.m_20256_(Dementor.this.m_20184_().m_82549_(vec3.m_82490_(this.f_24978_ * 0.05 / d0)));
                    if (Dementor.this.m_5448_() == null) {
                        Vec3 vec31 = Dementor.this.m_20184_();
                        Dementor.this.m_146922_(-((float)Mth.m_14136_((double)vec31.f_82479_, (double)vec31.f_82481_)) * 57.295776f);
                        Dementor.this.f_20883_ = Dementor.this.m_146908_();
                    } else {
                        double d2 = Dementor.this.m_5448_().m_20185_() - Dementor.this.m_20185_();
                        double d1 = Dementor.this.m_5448_().m_20189_() - Dementor.this.m_20189_();
                        Dementor.this.m_146922_(-((float)Mth.m_14136_((double)d2, (double)d1)) * 57.295776f);
                        Dementor.this.f_20883_ = Dementor.this.m_146908_();
                    }
                }
            }
        }
    }

    class VexChargeAttackGoal
    extends Goal {
        public VexChargeAttackGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (Dementor.this.m_5448_() != null && !Dementor.this.m_21566_().m_24995_() && Dementor.this.f_19796_.nextInt(VexChargeAttackGoal.m_186073_((int)7)) == 0) {
                return Dementor.this.m_20280_((Entity)Dementor.this.m_5448_()) > 4.0;
            }
            return false;
        }

        public boolean m_8045_() {
            return Dementor.this.m_21566_().m_24995_() && Dementor.this.isCharging() && Dementor.this.m_5448_() != null && Dementor.this.m_5448_().m_6084_();
        }

        public void m_8056_() {
            LivingEntity livingentity = Dementor.this.m_5448_();
            if (livingentity != null) {
                Vec3 vec3 = livingentity.m_146892_();
                Dementor.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
            }
            Dementor.this.setIsCharging(true);
            Dementor.this.m_5496_(SoundEvents.f_12500_, 1.0f, 1.0f);
        }

        public void m_8041_() {
            Dementor.this.setIsCharging(false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = Dementor.this.m_5448_();
            if (livingentity != null) {
                if (Dementor.this.m_142469_().m_82381_(livingentity.m_142469_())) {
                    Dementor.this.m_7327_((Entity)livingentity);
                    Dementor.this.setIsCharging(false);
                } else {
                    double d0 = Dementor.this.m_20280_((Entity)livingentity);
                    if (d0 < 9.0) {
                        Vec3 vec3 = livingentity.m_146892_();
                        Dementor.this.f_21342_.m_6849_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.0);
                    }
                }
            }
        }
    }

    class VexRandomMoveGoal
    extends Goal {
        public VexRandomMoveGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !Dementor.this.m_21566_().m_24995_() && Dementor.this.f_19796_.nextInt(VexRandomMoveGoal.m_186073_((int)7)) == 0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos blockpos = Dementor.this.getBoundOrigin();
            if (blockpos == null) {
                blockpos = Dementor.this.m_142538_();
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.m_142082_(Dementor.this.f_19796_.nextInt(15) - 7, Dementor.this.f_19796_.nextInt(11) - 5, Dementor.this.f_19796_.nextInt(15) - 7);
                if (!Dementor.this.f_19853_.m_46859_(blockpos1)) continue;
                Dementor.this.f_21342_.m_6849_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 0.25);
                if (Dementor.this.m_5448_() != null) break;
                Dementor.this.m_21563_().m_24950_((double)blockpos1.m_123341_() + 0.5, (double)blockpos1.m_123342_() + 0.5, (double)blockpos1.m_123343_() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

