/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.mobs.troll;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class Troll
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(Troll.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(Troll.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_CHARGING = SynchedEntityData.m_135353_(Troll.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int attackAnimationTick;

    public Troll(EntityType<? extends Troll> p_33786_, Level p_33787_) {
        super(p_33786_, p_33787_);
        this.f_21364_ = 15;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected boolean m_6149_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new TrollAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 1.0, 100.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_COLOR, (Object)1);
        this.f_19804_.m_135372_(DATA_IS_CHARGING, (Object)false);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR);
    }

    public void setColor(int p_30398_) {
        this.f_19804_.m_135381_(DATA_COLOR, (Object)p_30398_);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            // empty if block
        }
        if (this.attackAnimationTick > 0) {
            --this.attackAnimationTick;
        }
    }

    protected void m_6851_(DifficultyInstance p_21383_) {
        super.m_6851_(p_21383_);
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128344_("Color", (byte)this.getColor());
    }

    public void m_7378_(CompoundTag p_30402_) {
        super.m_7378_(p_30402_);
        if (p_30402_.m_128425_("Color", 99)) {
            this.setColor(p_30402_.m_128451_("Color"));
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22277_, 60.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 25.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_7327_(Entity p_21372_) {
        this.attackAnimationTick = 10;
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        p_21372_.m_20256_(p_21372_.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
        return super.m_7327_(p_21372_);
    }

    public void m_7822_(byte p_28844_) {
        if (p_28844_ == 4) {
            this.attackAnimationTick = 10;
        } else {
            super.m_7822_(p_28844_);
        }
    }

    public int getAttackAnimationTick() {
        return this.attackAnimationTick;
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CHARGING);
    }

    public void setCharging(boolean p_32759_) {
        this.f_19804_.m_135381_(DATA_IS_CHARGING, (Object)p_32759_);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33790_, DifficultyInstance p_33791_, MobSpawnType p_33792_, @Nullable SpawnGroupData p_33793_, @Nullable CompoundTag p_33794_) {
        MobEffect mobeffect;
        if ((p_33793_ = super.m_6518_(p_33790_, p_33791_, p_33792_, p_33793_, p_33794_)) == null) {
            p_33793_ = new TwohandEffectsGroupData();
            if (p_33790_.m_46791_() == Difficulty.HARD && p_33790_.m_5822_().nextFloat() < 0.1f * p_33791_.m_19057_()) {
                ((TwohandEffectsGroupData)p_33793_).setRandomEffect(p_33790_.m_5822_());
            }
        }
        if (p_33793_ instanceof TwohandEffectsGroupData && (mobeffect = ((TwohandEffectsGroupData)p_33793_).effect) != null) {
            this.m_7292_(new MobEffectInstance(mobeffect, Integer.MAX_VALUE));
        }
        int rand = new Random().nextInt(2) + 1;
        this.setColor(rand);
        this.m_21530_();
        return p_33793_;
    }

    protected float m_6431_(Pose p_33799_, EntityDimensions p_33800_) {
        return 0.65f;
    }

    static class TrollAttackGoal
    extends MeleeAttackGoal {
        public TrollAttackGoal(Troll p_33822_) {
            super((PathfinderMob)p_33822_, 1.0, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        public boolean m_8045_() {
            if (this.f_25540_.m_21187_().nextInt(100) == 0) {
                this.f_25540_.m_6710_((LivingEntity)null);
                return false;
            }
            return super.m_8045_();
        }

        protected double m_6639_(LivingEntity p_33825_) {
            return 15.0f + p_33825_.m_20205_();
        }
    }

    public static class TwohandEffectsGroupData
    implements SpawnGroupData {
        public MobEffect effect;

        public void setRandomEffect(Random p_33830_) {
            int i = p_33830_.nextInt(5);
            if (i <= 1) {
                this.effect = MobEffects.f_19596_;
            } else if (i <= 2) {
                this.effect = MobEffects.f_19600_;
            } else if (i <= 3) {
                this.effect = MobEffects.f_19605_;
            } else if (i <= 4) {
                this.effect = MobEffects.f_19609_;
            }
        }
    }
}

