/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.setup.config;

import net.minecraftforge.common.ForgeConfigSpec;

public final class CommonConfig {
    public final ForgeConfigSpec.ConfigValue<String> HOTBAR;
    final ForgeConfigSpec.IntValue[] DEATH_EATER = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> DEATH_EATER_BIOME;
    final ForgeConfigSpec.IntValue[] TROLL = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> TROLL_BIOME;
    final ForgeConfigSpec.IntValue[] DEMENTOR = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> DEMENTOR_BIOME;
    final ForgeConfigSpec.IntValue[] INFERIUS = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> INFERIUS_BIOME;
    final ForgeConfigSpec.IntValue[] ACROMANTULA = new ForgeConfigSpec.IntValue[3];
    final ForgeConfigSpec.ConfigValue<String> ACROMANTULA_BIOME;
    final ForgeConfigSpec.DoubleValue DEMENTOR_SPAWN_PERCENT;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        builder.comment("Spawn settings").push("spawnrate");
        this.HOTBAR = builder.comment("Hotbar placeholder").define("hotbar", (Object)"0;0;0;0;0;0;0;0;0");
        this.DEATH_EATER_BIOME = builder.comment("\nBiome name where the Death Eaters should spawn - leave it blank if it should spawn everywhere!").define("biome_name_1", (Object)"");
        this.TROLL_BIOME = builder.comment("\nBiome name where the Trolls should spawn").define("biome_name_2", (Object)"minecraft:swamp");
        this.DEMENTOR_BIOME = builder.comment("\nBiome name where the Dementors should spawn").define("biome_name_3", (Object)"");
        this.DEMENTOR_SPAWN_PERCENT = builder.comment("Spawn chance from killing villagers, golems or dementors.").translation("harrypotter.config.dementor.spawn_from").defineInRange("chance", 0.05, 0.0, 1.0);
        this.INFERIUS_BIOME = builder.comment("\nBiome name where Inferi should spawn").define("biome_name_4", (Object)"");
        this.ACROMANTULA_BIOME = builder.comment("\nBiome name where acromantulas should spawn").define("biome_name_5", (Object)"minecraft:dark_forest");
        CommonConfig.initMobSpawnRate(builder, "Death Eater", "death eater", 5, 0, 1, this.DEATH_EATER);
        CommonConfig.initMobSpawnRate(builder, "Troll", "troll", 10, 0, 1, this.TROLL);
        CommonConfig.initMobSpawnRate(builder, "Dementor", "dementor", 0, 0, 0, this.DEMENTOR);
        CommonConfig.initMobSpawnRate(builder, "Inferius", "inferius", 0, 0, 0, this.INFERIUS);
        CommonConfig.initMobSpawnRate(builder, "Acromantula", "acromantula", 10, 0, 1, this.ACROMANTULA);
        builder.pop();
    }

    public static void initMobSpawnRate(ForgeConfigSpec.Builder builder, String name, String pushname, int weight, int min, int max, ForgeConfigSpec.IntValue[] array) {
        builder.comment(name).push(pushname);
        array[0] = builder.comment("Spawn Chance").translation("harrypotter.config." + name + ".weight").defineInRange("weight", weight, 0, Integer.MAX_VALUE);
        array[1] = builder.comment("Monster Spawn Minimum Number").translation("harrypotter.config." + name + ".min").defineInRange("min", min, 0, Integer.MAX_VALUE);
        array[2] = builder.comment("Monster Spawn Maximum Number").translation("harrypotter.config." + name + ".max").defineInRange("max", max, 0, Integer.MAX_VALUE);
        builder.pop();
    }
}

