/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.setup.events;

import com.minecraftserverzone.harrypotter.broomsticks.BroomStick;
import com.minecraftserverzone.harrypotter.setup.Registrations;
import com.minecraftserverzone.harrypotter.setup.capabilities.PlayerStatsProvider;
import com.minecraftserverzone.harrypotter.setup.config.HarryPotterModConfig;
import com.minecraftserverzone.harrypotter.setup.network.Networking;
import com.minecraftserverzone.harrypotter.setup.network.PacketDataCDForAll;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="harrypotter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeSetup {
    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        if (event.getEntityLiving().m_20202_() != null && event.getEntityLiving().m_20202_() instanceof BroomStick && event.getSource() == DamageSource.f_19315_) {
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void changeCapabilityOfPlayers(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.m_5776_() && event.player.f_19797_ % 10 == 0) {
            Player player = event.player;
            player.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
                int[] allSpellCooldown = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                if (h.getSpellsCD() != null) {
                    allSpellCooldown = h.getSpellsCD();
                    if (h.getSpellsCD().length < 25) {
                        allSpellCooldown = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                        h.setSpellsCD(allSpellCooldown);
                    }
                    if (h.getSpellsCD().length == 25) {
                        for (int id = 0; id < 25; ++id) {
                            if (allSpellCooldown[id] <= 0) continue;
                            h.setSpellCD(h.getSpellsCD()[id] - 1, id);
                            Networking.sendToClient(new PacketDataCDForAll(id, h.getSpellsCD()[id], player.m_142081_()), (ServerPlayer)player);
                        }
                    }
                } else {
                    h.setSpellsCD(allSpellCooldown);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(og -> event.getEntity().getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
                h.setSpellsLevel(og.getSpellsLevel());
                int[] allSpellCooldown = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                h.setSpellsCD(allSpellCooldown);
            }));
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoadingEvent(BiomeLoadingEvent event) {
        MobSpawnSettingsBuilder spawns;
        if (event.getName() == null) {
            return;
        }
        String biomename = event.getName().toString();
        String[] spawnInBiomesList = ((String)HarryPotterModConfig.DEATH_EATER_BIOME.get()).split(",");
        if ((Integer)HarryPotterModConfig.DEATH_EATER[0].get() > 0) {
            spawns = event.getSpawns();
            if (HarryPotterModConfig.DEATH_EATER_BIOME.get() == "") {
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.DEATH_EATER.get(), ((Integer)HarryPotterModConfig.DEATH_EATER[0].get()).intValue(), ((Integer)HarryPotterModConfig.DEATH_EATER[1].get()).intValue(), ((Integer)HarryPotterModConfig.DEATH_EATER[2].get()).intValue()));
            }
            for (String list : spawnInBiomesList) {
                if (!biomename.equals(list)) continue;
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.DEATH_EATER.get(), ((Integer)HarryPotterModConfig.DEATH_EATER[0].get()).intValue(), ((Integer)HarryPotterModConfig.DEATH_EATER[1].get()).intValue(), ((Integer)HarryPotterModConfig.DEATH_EATER[2].get()).intValue()));
            }
        }
        spawnInBiomesList = ((String)HarryPotterModConfig.TROLL_BIOME.get()).split(",");
        if ((Integer)HarryPotterModConfig.TROLL[0].get() > 0) {
            spawns = event.getSpawns();
            if (HarryPotterModConfig.TROLL_BIOME.get() == "") {
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.TROLL.get(), ((Integer)HarryPotterModConfig.TROLL[0].get()).intValue(), ((Integer)HarryPotterModConfig.TROLL[1].get()).intValue(), ((Integer)HarryPotterModConfig.TROLL[2].get()).intValue()));
            }
            for (String list : spawnInBiomesList) {
                if (!biomename.equals(list)) continue;
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.TROLL.get(), ((Integer)HarryPotterModConfig.TROLL[0].get()).intValue(), ((Integer)HarryPotterModConfig.TROLL[1].get()).intValue(), ((Integer)HarryPotterModConfig.TROLL[2].get()).intValue()));
            }
        }
        spawnInBiomesList = ((String)HarryPotterModConfig.DEMENTOR_BIOME.get()).split(",");
        if ((Integer)HarryPotterModConfig.DEMENTOR[0].get() > 0) {
            spawns = event.getSpawns();
            if (HarryPotterModConfig.DEMENTOR_BIOME.get() == "") {
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.DEMENTOR.get(), ((Integer)HarryPotterModConfig.DEMENTOR[0].get()).intValue(), ((Integer)HarryPotterModConfig.DEMENTOR[1].get()).intValue(), ((Integer)HarryPotterModConfig.DEMENTOR[2].get()).intValue()));
            }
            for (String list : spawnInBiomesList) {
                if (!biomename.equals(list)) continue;
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.DEMENTOR.get(), ((Integer)HarryPotterModConfig.DEMENTOR[0].get()).intValue(), ((Integer)HarryPotterModConfig.DEMENTOR[1].get()).intValue(), ((Integer)HarryPotterModConfig.DEMENTOR[2].get()).intValue()));
            }
        }
        spawnInBiomesList = ((String)HarryPotterModConfig.INFERIUS_BIOME.get()).split(",");
        if ((Integer)HarryPotterModConfig.INFERIUS[0].get() > 0) {
            spawns = event.getSpawns();
            if (HarryPotterModConfig.INFERIUS_BIOME.get() == "") {
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.INFERIUS.get(), ((Integer)HarryPotterModConfig.INFERIUS[0].get()).intValue(), ((Integer)HarryPotterModConfig.INFERIUS[1].get()).intValue(), ((Integer)HarryPotterModConfig.INFERIUS[2].get()).intValue()));
            }
            for (String list : spawnInBiomesList) {
                if (!biomename.equals(list)) continue;
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.INFERIUS.get(), ((Integer)HarryPotterModConfig.INFERIUS[0].get()).intValue(), ((Integer)HarryPotterModConfig.INFERIUS[1].get()).intValue(), ((Integer)HarryPotterModConfig.INFERIUS[2].get()).intValue()));
            }
        }
        spawnInBiomesList = ((String)HarryPotterModConfig.ACROMANTULA_BIOME.get()).split(",");
        if ((Integer)HarryPotterModConfig.ACROMANTULA[0].get() > 0) {
            spawns = event.getSpawns();
            if (HarryPotterModConfig.ACROMANTULA_BIOME.get() == "") {
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.ACROMANTULA.get(), ((Integer)HarryPotterModConfig.ACROMANTULA[0].get()).intValue(), ((Integer)HarryPotterModConfig.ACROMANTULA[1].get()).intValue(), ((Integer)HarryPotterModConfig.ACROMANTULA[2].get()).intValue()));
            }
            for (String list : spawnInBiomesList) {
                if (!biomename.equals(list)) continue;
                spawns.getSpawner(MobCategory.MONSTER).add(new MobSpawnSettings.SpawnerData((EntityType)Registrations.ACROMANTULA.get(), ((Integer)HarryPotterModConfig.ACROMANTULA[0].get()).intValue(), ((Integer)HarryPotterModConfig.ACROMANTULA[1].get()).intValue(), ((Integer)HarryPotterModConfig.ACROMANTULA[2].get()).intValue()));
            }
        }
    }
}

