/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.setup.network;

import com.minecraftserverzone.harrypotter.setup.capabilities.PlayerStatsProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketDataCDForAll {
    private int spellNum;
    private int spellCD;
    private UUID uuid;

    public PacketDataCDForAll(FriendlyByteBuf buf) {
        this.spellNum = buf.readInt();
        this.spellCD = buf.readInt();
        this.uuid = buf.m_130259_();
    }

    public PacketDataCDForAll(int spellNum, int spellCD, UUID uuid) {
        this.spellNum = spellNum;
        this.spellCD = spellCD;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.spellNum);
        buf.writeInt(this.spellCD);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    public void playerChanged() {
        for (Player sp : Minecraft.m_91087_().f_91073_.m_6907_()) {
            if (!sp.m_142081_().equals(this.uuid)) continue;
            sp.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
                int[] allSpellCooldown = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                if (h.getSpellsCD() != null) {
                    if (h.getSpellsCD().length < 25) {
                        h.setSpellsCD(allSpellCooldown);
                    } else {
                        allSpellCooldown = h.getSpellsCD();
                    }
                } else {
                    h.setSpellsCD(allSpellCooldown);
                }
                h.setSpellCD(this.spellCD, this.spellNum);
            });
        }
    }
}

