/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.setup.network;

import com.minecraftserverzone.harrypotter.setup.capabilities.PlayerStatsProvider;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class PacketDataForAll {
    private int spellNum;
    private int[] spells;
    private UUID uuid;

    public PacketDataForAll(FriendlyByteBuf buf) {
        this.spellNum = buf.readInt();
        this.spells = buf.m_130100_();
        this.uuid = buf.m_130259_();
    }

    public PacketDataForAll(int spellNum, int[] spells, UUID uuid) {
        this.spellNum = spellNum;
        this.spells = spells;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.spellNum);
        buf.m_130089_(this.spells);
        buf.m_130077_(this.uuid);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.get().setPacketHandled(true);
    }

    public void playerChanged() {
        for (Player sp : Minecraft.m_91087_().f_91073_.m_6907_()) {
            if (!sp.m_142081_().equals(this.uuid)) continue;
            sp.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> h.setSpellsLevel(this.spells));
        }
    }
}

