/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.mobs.inferius;

import com.minecraftserverzone.harrypotter.mobs.inferius.InferiusAttackGoal;
import com.minecraftserverzone.harrypotter.setup.Registrations;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfig;

public class Inferius
extends Monster {
    private static final UUID SPEED_MODIFIER_BABY_UUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier SPEED_MODIFIER_BABY = new AttributeModifier(SPEED_MODIFIER_BABY_UUID, "Baby speed boost", 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> DATA_BABY_ID = SynchedEntityData.m_135353_(Inferius.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_SPECIAL_TYPE_ID = SynchedEntityData.m_135353_(Inferius.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final float ZOMBIE_LEADER_CHANCE = 0.05f;
    public static final int REINFORCEMENT_ATTEMPTS = 50;
    public static final int REINFORCEMENT_RANGE_MAX = 40;
    public static final int REINFORCEMENT_RANGE_MIN = 7;
    private static final Predicate<Difficulty> DOOR_BREAKING_PREDICATE = p_34284_ -> p_34284_ == Difficulty.HARD;
    public static final Predicate<LivingEntity> PREY_SELECTOR = p_30437_ -> {
        EntityType entitytype = p_30437_.m_6095_();
        return entitytype != Registrations.INFERIUS.get() && entitytype != Registrations.DEATH_EATER.get();
    };
    private final BreakDoorGoal breakDoorGoal = new BreakDoorGoal((Mob)this, DOOR_BREAKING_PREDICATE);
    private boolean canBreakDoors;

    public Inferius(EntityType<? extends Inferius> p_34271_, Level p_34272_) {
        super(p_34271_, p_34272_);
        this.f_21364_ = 4;
    }

    public boolean m_6149_() {
        return true;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.addBehaviourGoals();
    }

    protected void addBehaviourGoals() {
        this.f_21345_.m_25352_(2, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new InferiusAttackGoal(this, 1.0, false));
        this.f_21345_.m_25352_(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::canBreakDoors));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, PREY_SELECTOR));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 55.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 2.0).m_22266_(Attributes.f_22287_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_BABY_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_SPECIAL_TYPE_ID, (Object)0);
    }

    public boolean canBreakDoors() {
        return this.canBreakDoors;
    }

    public void setCanBreakDoors(boolean p_34337_) {
        if (this.supportsBreakDoorGoal() && GoalUtils.m_26894_((Mob)this)) {
            if (this.canBreakDoors != p_34337_) {
                this.canBreakDoors = p_34337_;
                ((GroundPathNavigation)this.m_21573_()).m_26477_(p_34337_);
                if (p_34337_) {
                    this.f_21345_.m_25352_(1, (Goal)this.breakDoorGoal);
                } else {
                    this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
                }
            }
        } else if (this.canBreakDoors) {
            this.f_21345_.m_25363_((Goal)this.breakDoorGoal);
            this.canBreakDoors = false;
        }
    }

    protected boolean supportsBreakDoorGoal() {
        return true;
    }

    public boolean m_6162_() {
        return (Boolean)this.m_20088_().m_135370_(DATA_BABY_ID);
    }

    public int m_213860_() {
        if (this.m_6162_()) {
            this.f_21364_ = (int)((double)this.f_21364_ * 2.5);
        }
        return super.m_213860_();
    }

    public void m_6863_(boolean p_34309_) {
        this.m_20088_().m_135381_(DATA_BABY_ID, (Object)p_34309_);
        if (this.f_19853_ != null && !this.f_19853_.f_46443_) {
            AttributeInstance attributeinstance = this.m_21051_(Attributes.f_22279_);
            attributeinstance.m_22130_(SPEED_MODIFIER_BABY);
            if (p_34309_) {
                attributeinstance.m_22118_(SPEED_MODIFIER_BABY);
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> p_34307_) {
        if (DATA_BABY_ID.equals(p_34307_)) {
            this.m_6210_();
        }
        super.m_7350_(p_34307_);
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
    }

    protected boolean isSunSensitive() {
        return false;
    }

    public boolean m_7327_(Entity p_34276_) {
        boolean flag = super.m_7327_(p_34276_);
        if (flag) {
            float f = this.f_19853_.m_6436_(this.m_20183_()).m_19056_();
            if (this.m_21205_().m_41619_() && this.m_6060_() && this.f_19796_.m_188501_() < f * 0.3f) {
                p_34276_.m_20254_(2 * (int)f);
            }
        }
        return flag;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12614_;
    }

    protected void m_7355_(BlockPos p_34316_, BlockState p_34317_) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_7380_(CompoundTag p_34319_) {
        super.m_7380_(p_34319_);
        p_34319_.m_128379_("IsBaby", this.m_6162_());
        p_34319_.m_128379_("CanBreakDoors", this.canBreakDoors());
    }

    public void m_7378_(CompoundTag p_34305_) {
        super.m_7378_(p_34305_);
        this.m_6863_(p_34305_.m_128471_("IsBaby"));
        this.setCanBreakDoors(p_34305_.m_128471_("CanBreakDoors"));
    }

    protected float m_6431_(Pose p_34313_, EntityDimensions p_34314_) {
        return this.m_6162_() ? 0.93f : 1.74f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34297_, DifficultyInstance p_34298_, MobSpawnType p_34299_, @Nullable SpawnGroupData p_34300_, @Nullable CompoundTag p_34301_) {
        p_34300_ = super.m_6518_(p_34297_, p_34298_, p_34299_, p_34300_, p_34301_);
        float f = p_34298_.m_19057_();
        if (p_34300_ == null) {
            p_34300_ = new InferiusGroupData(Inferius.getSpawnAsBabyOdds(p_34297_.m_213780_()));
        }
        if (p_34300_ instanceof InferiusGroupData) {
            InferiusGroupData zombie$zombiegroupdata = (InferiusGroupData)p_34300_;
            if (zombie$zombiegroupdata.isBaby) {
                this.m_6863_(true);
            }
            this.setCanBreakDoors(this.supportsBreakDoorGoal() && this.f_19796_.m_188501_() < f * 0.1f);
        }
        this.m_21530_();
        this.handleAttributes(f);
        return p_34300_;
    }

    public static boolean getSpawnAsBabyOdds(RandomSource p_34303_) {
        return p_34303_.m_188501_() < 0.05f;
    }

    protected void handleAttributes(float p_34340_) {
        this.randomizeReinforcementsChance();
        this.m_21051_(Attributes.f_22278_).m_22125_(new AttributeModifier("Random spawn bonus", this.f_19796_.m_188500_() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double d0 = this.f_19796_.m_188500_() * 1.5 * (double)p_34340_;
        if (d0 > 1.0) {
            this.m_21051_(Attributes.f_22277_).m_22125_(new AttributeModifier("Random zombie-spawn bonus", d0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.f_19796_.m_188501_() < p_34340_ * 0.05f) {
            this.m_21051_(Attributes.f_22287_).m_22125_(new AttributeModifier("Leader zombie bonus", this.f_19796_.m_188500_() * 0.25 + 0.5, AttributeModifier.Operation.ADDITION));
            this.m_21051_(Attributes.f_22276_).m_22125_(new AttributeModifier("Leader zombie bonus", this.f_19796_.m_188500_() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.setCanBreakDoors(this.supportsBreakDoorGoal());
        }
    }

    protected void randomizeReinforcementsChance() {
        this.m_21051_(Attributes.f_22287_).m_22100_(this.f_19796_.m_188500_() * (Double)ForgeConfig.SERVER.zombieBaseSummonChance.get());
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.45;
    }

    public static class InferiusGroupData
    implements SpawnGroupData {
        public final boolean isBaby;

        public InferiusGroupData(boolean p_34357_) {
            this.isBaby = p_34357_;
        }
    }
}

