/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.setup;

import com.google.gson.JsonElement;
import com.minecraftserverzone.harrypotter.datagen.ModBiomeTags;
import com.minecraftserverzone.harrypotter.setup.ModTags;
import com.minecraftserverzone.harrypotter.setup.Registrations;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="harrypotter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BiomeModifierTest {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "harrypotter";
    public static final ResourceLocation ADD_FEATURES_TO_BIOMES_RL = new ResourceLocation("harrypotter", "harry_potter_spawns");

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent event) {
        Object[][] SPAWNS = new Object[][]{{"spawn_acromantula", ModTags.HAS_ACROMANTULA, Registrations.ACROMANTULA.get()}, {"spawn_death_eater", ModTags.HAS_DEATH_EATER, Registrations.DEATH_EATER.get()}, {"spawn_dementor", ModTags.HAS_DEMENTOR, Registrations.DEMENTOR.get()}, {"spawn_inferius", ModTags.HAS_INFERIUS, Registrations.INFERIUS.get()}, {"spawn_troll", ModTags.HAS_TROLL, Registrations.TROLL.get()}};
        DataGenerator generator = event.getGenerator();
        Path outputFolder = generator.m_123916_();
        final RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)((RegistryAccess)RegistryAccess.f_123049_.get()));
        String directory = PackType.SERVER_DATA.m_10305_();
        ResourceLocation biomeModifiersRegistryID = ForgeRegistries.Keys.BIOME_MODIFIERS.m_135782_();
        for (int i = 0; i < SPAWNS.length; ++i) {
            final String biomeModifierPathString = String.join((CharSequence)"/", directory, MODID, biomeModifiersRegistryID.m_135827_(), biomeModifiersRegistryID.m_135815_(), SPAWNS[i][0] + ".json");
            final Path biomeModifierPath = outputFolder.resolve(biomeModifierPathString);
            final TestModifier biomeModifiersBrownScorpion = new TestModifier((HolderSet<Biome>)new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).get(), (TagKey)SPAWNS[i][1]), new MobSpawnSettings.SpawnerData((EntityType)SPAWNS[i][2], 5, 0, 2));
            if (event.includeServer()) {
                generator.m_236039_(true, (DataProvider)new ModBiomeTags(generator, event.getExistingFileHelper()));
            }
            generator.m_236039_(event.includeServer(), new DataProvider(){

                public void m_213708_(CachedOutput cache) throws IOException {
                    BiomeModifier.DIRECT_CODEC.encodeStart((DynamicOps)ops, (Object)biomeModifiersBrownScorpion).resultOrPartial(msg -> LOGGER.error("Failed to encode {}: {}", (Object)biomeModifierPathString, msg)).ifPresent(json -> {
                        try {
                            DataProvider.m_236072_((CachedOutput)cache, (JsonElement)json, (Path)biomeModifierPath);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }

                public String m_6055_() {
                    return "harrypotter data provider";
                }
            });
        }
    }

    public record TestModifier(HolderSet<Biome> biomes, MobSpawnSettings.SpawnerData spawn) implements BiomeModifier
    {
        private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)ADD_FEATURES_TO_BIOMES_RL, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"harrypotter");

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome)) {
                builder.getMobSpawnSettings().m_48376_(this.spawn.f_48404_.m_20674_(), this.spawn);
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return (Codec)SERIALIZER.get();
        }

        public static Codec<TestModifier> makeCodec() {
            return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(TestModifier::biomes), (App)MobSpawnSettings.SpawnerData.f_48403_.fieldOf("spawn").forGetter(TestModifier::spawn)).apply((Applicative)builder, TestModifier::new));
        }
    }
}

