/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.harrypotter.setup.events;

import com.minecraftserverzone.harrypotter.broomsticks.BroomStick;
import com.minecraftserverzone.harrypotter.setup.capabilities.PlayerStatsProvider;
import com.minecraftserverzone.harrypotter.setup.network.Networking;
import com.minecraftserverzone.harrypotter.setup.network.PacketDataCDForAll;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="harrypotter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeSetup {
    @SubscribeEvent
    public static void damageEvent(LivingDamageEvent event) {
        if (event.getEntityLiving().m_20202_() != null && event.getEntityLiving().m_20202_() instanceof BroomStick && event.getSource() == DamageSource.f_19315_) {
            event.setAmount(0.0f);
        }
    }

    @SubscribeEvent
    public static void changeCapabilityOfPlayers(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.f_19853_.m_5776_() && event.player.f_19797_ % 10 == 0) {
            Player player = event.player;
            player.getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
                int[] allSpellCooldown = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                if (h.getSpellsCD() != null) {
                    allSpellCooldown = h.getSpellsCD();
                    if (h.getSpellsCD().length < 25) {
                        allSpellCooldown = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                        h.setSpellsCD(allSpellCooldown);
                    }
                    if (h.getSpellsCD().length == 25) {
                        for (int id = 0; id < 25; ++id) {
                            if (allSpellCooldown[id] <= 0) continue;
                            h.setSpellCD(h.getSpellsCD()[id] - 1, id);
                            Networking.sendToClient(new PacketDataCDForAll(id, h.getSpellsCD()[id], player.m_20148_()), (ServerPlayer)player);
                        }
                    }
                } else {
                    h.setSpellsCD(allSpellCooldown);
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().reviveCaps();
            event.getOriginal().getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(og -> event.getEntity().getCapability(PlayerStatsProvider.PLAYER_STATS_CAPABILITY).ifPresent(h -> {
                h.setSpellsLevel(og.getSpellsLevel());
                int[] allSpellCooldown = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                h.setSpellsCD(allSpellCooldown);
            }));
            event.getOriginal().invalidateCaps();
        }
    }
}

