/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.horsecombatcontrols;

import github.pitbox46.horsecombatcontrols.CombatModeAccessor;
import github.pitbox46.horsecombatcontrols.Config;
import github.pitbox46.horsecombatcontrols.network.ClientProxy;
import github.pitbox46.horsecombatcontrols.network.CombatModePacket;
import github.pitbox46.horsecombatcontrols.network.CommonProxy;
import github.pitbox46.horsecombatcontrols.network.PacketHandler;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="horsecombatcontrols")
public class HorseCombatControls {
    public static final Logger LOGGER = LogManager.getLogger();
    private static KeyMapping toggleControls;
    public static CommonProxy PROXY;
    private int tick = 0;

    public HorseCombatControls() {
        PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isInCombatMode(Player player) {
        return ((CombatModeAccessor)player).inCombatMode();
    }

    public static void setCombatModeClientVersion(Player player, boolean flag) {
        ((CombatModeAccessor)player).setCombatMode(flag);
        PacketHandler.CHANNEL.sendToServer((Object)new CombatModePacket(flag));
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        toggleControls = new KeyMapping("key.horsecombatcontrols.toggle", 89, "key.horsecombatcontrols.category");
        ClientRegistry.registerKeyBinding((KeyMapping)toggleControls);
    }

    @SubscribeEvent
    public void onPlayerLog(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player2), (Object)new CombatModePacket(HorseCombatControls.isInCombatMode((Player)player2)));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && event.phase == TickEvent.Phase.END) {
            if (toggleControls.m_90859_()) {
                if (((Boolean)Config.LOCK_COMBAT_MODE.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.horsecombatcontrols.locked"), true);
                    HorseCombatControls.setCombatModeClientVersion((Player)player, true);
                } else {
                    HorseCombatControls.setCombatModeClientVersion((Player)player, !HorseCombatControls.isInCombatMode((Player)player));
                }
            }
            if (this.tick++ > 100 && ((Boolean)Config.LOCK_COMBAT_MODE.get()).booleanValue()) {
                HorseCombatControls.setCombatModeClientVersion((Player)player, true);
                this.tick = 0;
            }
        }
    }
}

