/*
 * Decompiled with CFR 0.152.
 */
package github.pitbox46.horsecombatcontrols.mixins;

import github.pitbox46.horsecombatcontrols.CombatModeAccessor;
import github.pitbox46.horsecombatcontrols.Config;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends Entity
implements CombatModeAccessor {
    private boolean combatMode = false;

    public PlayerMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    private void onAddAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128379_("combatMode", this.inCombatMode());
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    private void onReadAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        if (pCompound.m_128441_("combatMode")) {
            this.setCombatMode(pCompound.m_128471_("combatMode"));
        } else {
            this.setCombatMode((Boolean)Config.LOCK_COMBAT_MODE.get());
        }
    }

    @Override
    public boolean inCombatMode() {
        return (Boolean)Config.LOCK_COMBAT_MODE.get() != false || this.combatMode;
    }

    @Override
    public void setCombatMode(boolean flag) {
        this.combatMode = (Boolean)Config.LOCK_COMBAT_MODE.get() != false || flag;
    }
}

