/*
 * Decompiled with CFR 0.152.
 */
package dev.intelligentcreations.hudium.api.info.plugin;

import dev.intelligentcreations.hudium.HudiumClient;
import dev.intelligentcreations.hudium.api.info.plugin.InfoPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class InfoPluginHandler {
    private static final List<InfoPlugin> plugins = new ArrayList<InfoPlugin>();

    public static <T extends InfoPlugin> void register(Class<T> pluginClass) {
        try {
            InfoPlugin plugin = (InfoPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            plugins.add(plugin);
            HudiumClient.LOGGER.info("Registered plugin " + pluginClass.getName());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException("No valid constructor found for " + pluginClass.getName());
        }
    }

    public static List<InfoPlugin> getPlugins() {
        return plugins;
    }
}

