/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience;

import electrodynamics.prefab.configuration.ConfigurationHandler;
import net.minecraft.potion.Effect;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import nuclearscience.DeferredRegisters;
import nuclearscience.SoundRegister;
import nuclearscience.api.radiation.EffectRadiation;
import nuclearscience.api.radiation.FieldRadioactiveObject;
import nuclearscience.api.radiation.RadiationRegister;
import nuclearscience.client.ClientRegister;
import nuclearscience.common.packet.NetworkHandler;
import nuclearscience.common.recipe.NuclearScienceRecipeInit;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tags.NuclearScienceTags;

@Mod(value="nuclearscience")
@Mod.EventBusSubscriber(modid="nuclearscience", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NuclearScience {
    public NuclearScience() {
        ConfigurationHandler.registerConfig(Constants.class);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        DeferredRegisters.BLOCKS.register(bus);
        DeferredRegisters.ITEMS.register(bus);
        DeferredRegisters.TILES.register(bus);
        DeferredRegisters.CONTAINERS.register(bus);
        DeferredRegisters.FLUIDS.register(bus);
        DeferredRegisters.ENTITIES.register(bus);
        NuclearScienceRecipeInit.RECIPE_SERIALIZER.register(bus);
        SoundRegister.SOUNDS.register(bus);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onClientSetup(FMLClientSetupEvent event) {
        ClientRegister.setup();
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        NetworkHandler.init();
        NuclearScienceTags.init();
    }

    @SubscribeEvent
    public static void onLoadEvent(FMLLoadCompleteEvent event) {
        RadiationRegister.register(DeferredRegisters.ITEM_URANIUM235.get(), new FieldRadioactiveObject(1000.0));
        RadiationRegister.register(DeferredRegisters.ITEM_URANIUM238.get(), new FieldRadioactiveObject(500.0));
        RadiationRegister.register(DeferredRegisters.ITEM_YELLOWCAKE.get(), new FieldRadioactiveObject(300.0));
        RadiationRegister.register(DeferredRegisters.ITEM_FUELHEUO2.get(), new FieldRadioactiveObject(3000.0));
        RadiationRegister.register(DeferredRegisters.ITEM_FUELLEUO2.get(), new FieldRadioactiveObject(2000.0));
        RadiationRegister.register(DeferredRegisters.ITEM_FUELSPENT.get(), new FieldRadioactiveObject(3500.0));
        RadiationRegister.register(DeferredRegisters.ITEM_FUELPLUTONIUM.get(), new FieldRadioactiveObject(2500.0));
        RadiationRegister.register(DeferredRegisters.ITEM_FISSILEDUST.get(), new FieldRadioactiveObject(2000.0));
        RadiationRegister.register(DeferredRegisters.ITEM_PLUTONIUMOXIDE.get(), new FieldRadioactiveObject(4000.0));
        RadiationRegister.register(DeferredRegisters.ITEM_PLUTONIUM239.get(), new FieldRadioactiveObject(4500.0));
        RadiationRegister.register(DeferredRegisters.ITEM_THORIANITEDUST.get(), new FieldRadioactiveObject(2000.0));
    }

    @SubscribeEvent
    public static void registerEffects(RegistryEvent.Register<Effect> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Effect[]{EffectRadiation.INSTANCE});
    }
}

