/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.api.radiation;

import electrodynamics.prefab.utilities.object.Location;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.radiation.EffectRadiation;
import nuclearscience.common.item.ItemGeigerCounter;
import nuclearscience.common.item.ItemHazmatArmor;

@Mod.EventBusSubscriber(modid="nuclearscience", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RadiationSystem {
    public static HashMap<PlayerEntity, Double> radiationMap = new HashMap();

    public static double getRadiationModifier(World world, Location source, Location end) {
        double distance = 1.0 + source.distance(end);
        Location clone = new Location(end);
        double modifier = 1.0;
        Location newSource = new Location(source);
        clone.add(-source.x(), -source.y(), -source.z()).normalize().mul((double)0.33f);
        BlockPos curr = newSource.toBlockPos();
        double lastHard = 0.0;
        for (int checks = (int)distance * 3; checks > 0; --checks) {
            newSource.add(clone);
            double hard = lastHard;
            BlockPos next = newSource.toBlockPos();
            if (!curr.equals((Object)next)) {
                curr = next;
                BlockState state = world.func_180495_p(curr);
                lastHard = hard = (double)(state.func_177230_c() == DeferredRegisters.blocklead ? 20000.0f : state.func_185887_b((IBlockReader)world, curr)) / (world.func_204610_c(curr).func_206888_e() ? 1.0 : 50.0);
            }
            modifier += hard / 4.5;
        }
        return modifier;
    }

    public static double getRadiation(World world, Location source, Location end, double strength) {
        double distance = 1.0 + source.distance(end);
        return strength / (RadiationSystem.getRadiationModifier(world, source, end) * distance * distance);
    }

    public static void applyRadiation(LivingEntity entity, Location source, double strength) {
        int protection = 1;
        if (!entity.field_70170_p.field_72995_K) {
            PlayerEntity player;
            boolean isPlayer = entity instanceof PlayerEntity;
            if (isPlayer && !(player = (PlayerEntity)entity).func_184812_l_()) {
                for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
                    ItemStack next = (ItemStack)player.field_71071_by.field_70460_b.get(i);
                    if (!(next.func_77973_b() instanceof ItemHazmatArmor)) continue;
                    ++protection;
                    float damage = (float)(strength * (double)2.15f) / 2169.9976f;
                    if (!(Math.random() < (double)damage)) continue;
                    int integerDamage = (int)Math.max(1.0f, damage);
                    if (next.func_77952_i() <= next.func_77958_k() && !next.func_96631_a(integerDamage, entity.field_70170_p.field_73012_v, (ServerPlayerEntity)player)) continue;
                    player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
                }
            }
            Location end = new Location(entity.func_213303_ch());
            double radiation = 0.0;
            if (entity instanceof PlayerEntity && (((PlayerEntity)entity).func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() instanceof ItemGeigerCounter || ((PlayerEntity)entity).func_184582_a(EquipmentSlotType.OFFHAND).func_77973_b() instanceof ItemGeigerCounter)) {
                double already = radiationMap.containsKey(entity) ? radiationMap.get(entity) : 0.0;
                radiation = RadiationSystem.getRadiation(entity.field_70170_p, source, end, strength);
                radiationMap.put((PlayerEntity)entity, already + radiation);
            }
            if (!(entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() || protection >= 5 || !(radiationMap.getOrDefault(entity, 11.0) > 4.0))) {
                if (radiation == 0.0) {
                    radiation = RadiationSystem.getRadiation(entity.field_70170_p, source, end, strength);
                }
                double distance = 1.0 + source.distance(end);
                double modifier = strength / (radiation * distance * distance);
                int amplitude = (int)Math.max(0.0, Math.min(strength / modifier / (distance * 4000.0), 9.0));
                int time = (int)(strength / modifier / ((double)(amplitude + 1) * distance));
                if (amplitude == 0 && time <= 40) {
                    return;
                }
                entity.func_195064_c(new EffectInstance((Effect)EffectRadiation.INSTANCE, time, Math.min(40, amplitude), false, true));
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            radiationMap.clear();
        }
    }
}

