/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import electrodynamics.DeferredRegisters;
import electrodynamics.api.electricity.formatting.ChatFormatter;
import electrodynamics.api.electricity.formatting.ElectricUnit;
import electrodynamics.api.screen.IScreenWrapper;
import electrodynamics.common.item.subtype.SubtypeProcessorUpgrade;
import electrodynamics.prefab.inventory.container.GenericContainer;
import electrodynamics.prefab.inventory.container.slot.SlotRestricted;
import electrodynamics.prefab.screen.GenericScreen;
import electrodynamics.prefab.screen.component.ScreenComponentElectricInfo;
import electrodynamics.prefab.screen.component.ScreenComponentFluid;
import electrodynamics.prefab.screen.component.ScreenComponentProgress;
import electrodynamics.prefab.screen.component.ScreenComponentSlot;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentProcessor;
import electrodynamics.prefab.tile.components.utils.AbstractFluidHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import nuclearscience.common.inventory.container.ContainerMSRFuelPreProcessor;
import nuclearscience.common.tile.TileMSRFuelPreProcessor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenMSRFuelPreProcessor
extends GenericScreen<ContainerMSRFuelPreProcessor> {
    public ScreenMSRFuelPreProcessor(ContainerMSRFuelPreProcessor container, PlayerInventory playerInventory, ITextComponent title) {
        super((GenericContainer)container, playerInventory, title);
        this.components.add(new ScreenComponentProgress(() -> {
            GenericTile furnace = (GenericTile)container.getHostFromIntArray();
            if (furnace != null) {
                ComponentProcessor processor = (ComponentProcessor)furnace.getComponent(ComponentType.Processor);
                if (processor.operatingTicks > 0.0) {
                    return Math.min(1.0, processor.operatingTicks / ((double)processor.requiredTicks / 2.0));
                }
            }
            return 0.0;
        }, (IScreenWrapper)this, 42, 30));
        this.components.add(new ScreenComponentProgress(() -> {
            GenericTile furnace = (GenericTile)container.getHostFromIntArray();
            if (furnace != null) {
                ComponentProcessor processor = (ComponentProcessor)furnace.getComponent(ComponentType.Processor);
                if (processor.operatingTicks > (double)processor.requiredTicks / 2.0) {
                    return Math.min(1.0, (processor.operatingTicks - (double)processor.requiredTicks / 2.0) / ((double)processor.requiredTicks / 2.0));
                }
            }
            return 0.0;
        }, (IScreenWrapper)this, 98, 40));
        this.components.add(new ScreenComponentFluid(() -> {
            TileMSRFuelPreProcessor boiler = (TileMSRFuelPreProcessor)container.getHostFromIntArray();
            if (boiler != null) {
                AbstractFluidHandler handler = (AbstractFluidHandler)boiler.getComponent(ComponentType.FluidHandler);
                for (Fluid fluid : handler.getValidInputFluids()) {
                    FluidTank tank = handler.getTankFromFluid(fluid, true);
                    if (tank.getFluidAmount() <= 0) continue;
                    return tank;
                }
            }
            return null;
        }, (IScreenWrapper)this, 21, 18));
        this.components.add(new ScreenComponentElectricInfo(this::getEnergyInformation, (IScreenWrapper)this, -25, 2));
    }

    protected ScreenComponentSlot createScreenSlot(Slot slot) {
        return new ScreenComponentSlot(slot instanceof SlotRestricted && ((SlotRestricted)slot).func_75214_a(new ItemStack((IItemProvider)DeferredRegisters.SUBTYPEITEM_MAPPINGS.get(SubtypeProcessorUpgrade.basicspeed))) ? ScreenComponentSlot.EnumSlotType.SPEED : (slot instanceof SlotRestricted ? ScreenComponentSlot.EnumSlotType.LIQUID : ScreenComponentSlot.EnumSlotType.NORMAL), (IScreenWrapper)this, slot.field_75223_e - 1, slot.field_75221_f - 1);
    }

    private List<? extends ITextProperties> getEnergyInformation() {
        ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
        GenericTile box = (GenericTile)((ContainerMSRFuelPreProcessor)this.field_147002_h).getHostFromIntArray();
        if (box != null) {
            ComponentElectrodynamic electro = (ComponentElectrodynamic)box.getComponent(ComponentType.Electrodynamic);
            ComponentProcessor processor = (ComponentProcessor)box.getComponent(ComponentType.Processor);
            list.add(new TranslationTextComponent("gui.chemicalmixer.usage", new Object[]{new StringTextComponent(ChatFormatter.getElectricDisplayShort((double)(processor.getUsage() * 20.0), (ElectricUnit)ElectricUnit.WATT)).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
            list.add(new TranslationTextComponent("gui.chemicalmixer.voltage", new Object[]{new StringTextComponent(ChatFormatter.getElectricDisplayShort((double)electro.getVoltage(), (ElectricUnit)ElectricUnit.VOLTAGE)).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        }
        return list;
    }
}

