/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import electrodynamics.api.electricity.formatting.ChatFormatter;
import electrodynamics.api.electricity.formatting.ElectricUnit;
import electrodynamics.api.screen.IScreenWrapper;
import electrodynamics.prefab.inventory.container.GenericContainer;
import electrodynamics.prefab.screen.GenericScreen;
import electrodynamics.prefab.screen.component.ScreenComponentTextInputBar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nuclearscience.common.inventory.container.ContainerQuantumCapacitor;
import nuclearscience.common.packet.NetworkHandler;
import nuclearscience.common.packet.PacketSetQuantumCapacitorData;
import nuclearscience.common.tile.TileQuantumCapacitor;

@OnlyIn(value=Dist.CLIENT)
public class ScreenQuantumCapacitor
extends GenericScreen<ContainerQuantumCapacitor> {
    private TextFieldWidget outputField;
    private TextFieldWidget frequencyField;
    private boolean needsUpdate = true;

    public ScreenQuantumCapacitor(ContainerQuantumCapacitor container, PlayerInventory playerInventory, ITextComponent title) {
        super((GenericContainer)container, playerInventory, title);
        this.components.add(new ScreenComponentTextInputBar((IScreenWrapper)this, 115, 14));
        this.components.add(new ScreenComponentTextInputBar((IScreenWrapper)this, 115, 34));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.outputField.func_146178_a();
        this.frequencyField.func_146178_a();
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.initFields();
    }

    protected void initFields() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.outputField = new TextFieldWidget(this.field_230712_o_, i + 120, j + 18, 46, 13, (ITextComponent)new TranslationTextComponent("container.quantumcapacitor.joulesoutput"));
        this.outputField.func_146193_g(-1);
        this.outputField.func_146204_h(-1);
        this.outputField.func_146185_a(false);
        this.outputField.func_146203_f(6);
        this.outputField.func_212954_a(this::updateOutput);
        this.frequencyField = new TextFieldWidget(this.field_230712_o_, i + 120, j + 18 + 20, 46, 13, (ITextComponent)new TranslationTextComponent("container.quantumcapacitor.frequency"));
        this.frequencyField.func_146193_g(-1);
        this.frequencyField.func_146204_h(-1);
        this.frequencyField.func_146185_a(false);
        this.frequencyField.func_146203_f(6);
        this.frequencyField.func_212954_a(this::updateFreq);
        this.field_230705_e_.add(this.outputField);
        this.field_230705_e_.add(this.frequencyField);
    }

    private void updateValues(String coord) {
        if (!coord.isEmpty()) {
            Double triedOutput = 0.0;
            try {
                triedOutput = Double.parseDouble(this.outputField.func_146179_b());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Integer frequency = 0;
            try {
                frequency = Integer.parseInt(this.frequencyField.func_146179_b());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((ContainerQuantumCapacitor)this.field_147002_h).getHostFromIntArray() != null) {
                NetworkHandler.CHANNEL.sendToServer((Object)new PacketSetQuantumCapacitorData(((TileQuantumCapacitor)((ContainerQuantumCapacitor)this.field_147002_h).getHostFromIntArray()).func_174877_v(), triedOutput, frequency));
            }
        }
    }

    private void updateFreq(String val) {
        this.frequencyField.func_146195_b(true);
        this.outputField.func_146195_b(false);
        this.updateValues(val);
    }

    private void updateOutput(String val) {
        this.frequencyField.func_146195_b(false);
        this.outputField.func_146195_b(true);
        this.updateValues(val);
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        String s = this.outputField.func_146179_b();
        String s1 = this.frequencyField.func_146179_b();
        this.func_231158_b_(minecraft, width, height);
        this.outputField.func_146180_a(s);
        this.frequencyField.func_146180_a(s1);
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.needsUpdate && ((ContainerQuantumCapacitor)this.field_147002_h).getHostFromIntArray() != null) {
            this.needsUpdate = false;
            this.outputField.func_146180_a("" + ((TileQuantumCapacitor)((ContainerQuantumCapacitor)this.field_147002_h).getHostFromIntArray()).outputJoules);
            this.frequencyField.func_146180_a("" + ((TileQuantumCapacitor)((ContainerQuantumCapacitor)this.field_147002_h).getHostFromIntArray()).frequency);
        }
        this.outputField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.frequencyField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        TileQuantumCapacitor box = (TileQuantumCapacitor)((ContainerQuantumCapacitor)this.field_147002_h).getHostFromIntArray();
        if (box != null) {
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("gui.quantumcapacitor.current", new Object[]{ChatFormatter.getElectricDisplayShort((double)(box.getOutputJoules() * 20.0 / 1920.0), (ElectricUnit)ElectricUnit.AMPERE)}), (float)this.field_238744_r_, (float)this.field_238745_s_ - 55.0f, 0x404040);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("gui.quantumcapacitor.transfer", new Object[]{ChatFormatter.getElectricDisplayShort((double)(box.getOutputJoules() * 20.0), (ElectricUnit)ElectricUnit.WATT)}), (float)this.field_238744_r_, (float)this.field_238745_s_ - 42.0f, 0x404040);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("gui.quantumcapacitor.voltage", new Object[]{ChatFormatter.getElectricDisplayShort((double)1920.0, (ElectricUnit)ElectricUnit.VOLTAGE)}), (float)this.field_238744_r_, (float)this.field_238745_s_ - 29.0f, 0x404040);
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("gui.quantumcapacitor.stored", new Object[]{ChatFormatter.getElectricDisplayShort((double)box.joulesClient, (ElectricUnit)ElectricUnit.JOULES) + " / " + ChatFormatter.getElectricDisplayShort((double)Double.MAX_VALUE, (ElectricUnit)ElectricUnit.JOULES)}), (float)this.field_238744_r_, (float)this.field_238745_s_ - 16.0f, 0x404040);
        }
    }
}

