/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import electrodynamics.api.electricity.formatting.ChatFormatter;
import electrodynamics.api.electricity.formatting.ElectricUnit;
import electrodynamics.api.screen.IScreenWrapper;
import electrodynamics.prefab.inventory.container.GenericContainer;
import electrodynamics.prefab.screen.GenericScreen;
import electrodynamics.prefab.screen.component.ScreenComponentElectricInfo;
import electrodynamics.prefab.screen.component.ScreenComponentProgress;
import electrodynamics.prefab.utilities.object.TransferPack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nuclearscience.api.radiation.IRadioactiveObject;
import nuclearscience.api.radiation.RadiationRegister;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.Constants;

@OnlyIn(value=Dist.CLIENT)
public class ScreenRadioisotopeGenerator
extends GenericScreen<ContainerRadioisotopeGenerator> {
    public ScreenRadioisotopeGenerator(ContainerRadioisotopeGenerator container, PlayerInventory playerInventory, ITextComponent title) {
        super((GenericContainer)container, playerInventory, title);
        this.components.add(new ScreenComponentProgress(() -> {
            ItemStack in = container.func_75139_a(0).func_75211_c();
            IRadioactiveObject rad = RadiationRegister.get(in.func_77973_b());
            double currentOutput = (double)in.func_190916_E() * Constants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.getRadiationStrength();
            if (currentOutput > 0.0) {
                return 1.0;
            }
            return 0.0;
        }, (IScreenWrapper)this, 25, 24).flame());
        this.components.add(new ScreenComponentElectricInfo(this::getEnergyInformation, (IScreenWrapper)this, -25, 2));
    }

    private List<? extends ITextProperties> getEnergyInformation() {
        ArrayList<IFormattableTextComponent> list = new ArrayList<IFormattableTextComponent>();
        ItemStack in = ((ContainerRadioisotopeGenerator)this.field_147002_h).func_75139_a(0).func_75211_c();
        IRadioactiveObject rad = RadiationRegister.get(in.func_77973_b());
        double currentOutput = (double)in.func_190916_E() * Constants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.getRadiationStrength();
        TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / Constants.RADIOISOTOPEGENERATOR_VOLTAGE), (double)Constants.RADIOISOTOPEGENERATOR_VOLTAGE);
        list.add(new TranslationTextComponent("gui.radioisotopegenerator.current", new Object[]{new StringTextComponent(ChatFormatter.getElectricDisplayShort((double)transfer.getAmps(), (ElectricUnit)ElectricUnit.AMPERE)).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        list.add(new TranslationTextComponent("gui.radioisotopegenerator.output", new Object[]{new StringTextComponent(ChatFormatter.getElectricDisplayShort((double)transfer.getWatts(), (ElectricUnit)ElectricUnit.WATT)).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        list.add(new TranslationTextComponent("gui.radioisotopegenerator.voltage", new Object[]{new StringTextComponent(ChatFormatter.getElectricDisplayShort((double)transfer.getVoltage(), (ElectricUnit)ElectricUnit.VOLTAGE)).func_240699_a_(TextFormatting.GRAY)}).func_240699_a_(TextFormatting.DARK_GRAY));
        return list;
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        ItemStack in = ((ContainerRadioisotopeGenerator)this.field_147002_h).func_75139_a(0).func_75211_c();
        IRadioactiveObject rad = RadiationRegister.get(in.func_77973_b());
        double currentOutput = (double)in.func_190916_E() * Constants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.getRadiationStrength();
        TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / Constants.RADIOISOTOPEGENERATOR_VOLTAGE), (double)Constants.RADIOISOTOPEGENERATOR_VOLTAGE);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("gui.radioisotopegenerator.current", new Object[]{ChatFormatter.getElectricDisplayShort((double)transfer.getAmps(), (ElectricUnit)ElectricUnit.AMPERE)}), (float)this.field_238744_r_ + 60.0f, (float)this.field_238745_s_ - 48.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("gui.radioisotopegenerator.output", new Object[]{ChatFormatter.getElectricDisplayShort((double)transfer.getWatts(), (ElectricUnit)ElectricUnit.WATT)}), (float)this.field_238744_r_ + 60.0f, (float)this.field_238745_s_ - 35.0f, 0x404040);
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("gui.radioisotopegenerator.voltage", new Object[]{ChatFormatter.getElectricDisplayShort((double)transfer.getVoltage(), (ElectricUnit)ElectricUnit.VOLTAGE)}), (float)this.field_238744_r_ + 60.0f, (float)this.field_238745_s_ - 22.0f, 0x404040);
    }
}

