/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.block.connect;

import com.google.common.collect.Maps;
import electrodynamics.DeferredRegisters;
import electrodynamics.common.block.connect.EnumConnectType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import nuclearscience.api.network.moltensalt.IMoltenSaltPipe;
import nuclearscience.common.block.subtype.SubtypeMoltenSaltPipe;
import nuclearscience.common.tile.TileHeatExchanger;
import nuclearscience.common.tile.TileMSRReactorCore;
import nuclearscience.common.tile.network.TileMoltenSaltPipe;

public class BlockMoltenSaltPipe
extends Block
implements IWaterLoggable {
    public static final Map<Direction, EnumProperty<EnumConnectType>> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), p -> {
        p.put(Direction.NORTH, EnumConnectType.NORTH);
        p.put(Direction.EAST, EnumConnectType.EAST);
        p.put(Direction.SOUTH, EnumConnectType.SOUTH);
        p.put(Direction.WEST, EnumConnectType.WEST);
        p.put(Direction.UP, EnumConnectType.UP);
        p.put(Direction.DOWN, EnumConnectType.DOWN);
    });
    public static final HashSet<Block> PIPESET = new HashSet();
    protected final VoxelShape cube;
    protected final VoxelShape cubeup;
    protected final VoxelShape cubedown;
    protected final VoxelShape cubenorth;
    protected final VoxelShape cubesouth;
    protected final VoxelShape cubewest;
    protected final VoxelShape cubeeast;
    protected HashMap<HashSet<Direction>, VoxelShape> shapestates = new HashMap();
    protected boolean locked = false;
    public final SubtypeMoltenSaltPipe pipe;

    public BlockMoltenSaltPipe(SubtypeMoltenSaltPipe pipe) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(0.15f).func_208770_d());
        this.pipe = pipe;
        double w = 3.0;
        double sm = 8.0 - w;
        double lg = 8.0 + w;
        this.cube = Block.func_208617_a((double)sm, (double)sm, (double)sm, (double)lg, (double)lg, (double)lg);
        this.cubeup = Block.func_208617_a((double)sm, (double)sm, (double)sm, (double)lg, (double)16.0, (double)lg);
        this.cubedown = Block.func_208617_a((double)sm, (double)0.0, (double)sm, (double)lg, (double)lg, (double)lg);
        this.cubenorth = Block.func_208617_a((double)sm, (double)sm, (double)0.0, (double)lg, (double)lg, (double)lg);
        this.cubesouth = Block.func_208617_a((double)sm, (double)sm, (double)sm, (double)lg, (double)lg, (double)16.0);
        this.cubewest = Block.func_208617_a((double)0.0, (double)sm, (double)sm, (double)lg, (double)lg, (double)lg);
        this.cubeeast = Block.func_208617_a((double)sm, (double)sm, (double)sm, (double)16.0, (double)lg, (double)lg);
        PIPESET.add(this);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    @Deprecated
    public FluidState func_204507_t(BlockState state) {
        return state.func_177229_b((Property)BlockStateProperties.field_208198_y) == Boolean.TRUE ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Arrays.asList(new ItemStack((IItemProvider)DeferredRegisters.SUBTYPEITEM_MAPPINGS.get((Object)this.pipe)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{EnumConnectType.UP, EnumConnectType.DOWN, EnumConnectType.NORTH, EnumConnectType.EAST, EnumConnectType.SOUTH, EnumConnectType.WEST});
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208198_y});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape shape = this.cube;
        HashSet<Direction> checked = new HashSet<Direction>();
        if (!((EnumConnectType)state.func_177229_b((Property)EnumConnectType.UP)).equals((Object)EnumConnectType.NONE)) {
            checked.add(Direction.UP);
        }
        if (!((EnumConnectType)state.func_177229_b((Property)EnumConnectType.DOWN)).equals((Object)EnumConnectType.NONE)) {
            checked.add(Direction.DOWN);
        }
        if (!((EnumConnectType)state.func_177229_b((Property)EnumConnectType.WEST)).equals((Object)EnumConnectType.NONE)) {
            checked.add(Direction.WEST);
        }
        if (!((EnumConnectType)state.func_177229_b((Property)EnumConnectType.EAST)).equals((Object)EnumConnectType.NONE)) {
            checked.add(Direction.EAST);
        }
        if (!((EnumConnectType)state.func_177229_b((Property)EnumConnectType.NORTH)).equals((Object)EnumConnectType.NONE)) {
            checked.add(Direction.NORTH);
        }
        if (!((EnumConnectType)state.func_177229_b((Property)EnumConnectType.SOUTH)).equals((Object)EnumConnectType.NONE)) {
            checked.add(Direction.SOUTH);
        }
        this.locked = true;
        if (this.shapestates.containsKey(checked)) {
            this.locked = false;
            return this.shapestates.get(checked);
        }
        this.locked = false;
        for (Direction dir : checked) {
            switch (dir) {
                case DOWN: {
                    shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)this.cubedown, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    break;
                }
                case EAST: {
                    shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)this.cubeeast, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    break;
                }
                case NORTH: {
                    shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)this.cubenorth, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    break;
                }
                case SOUTH: {
                    shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)this.cubesouth, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    break;
                }
                case UP: {
                    shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)this.cubeup, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    break;
                }
                case WEST: {
                    shape = VoxelShapes.func_197878_a((VoxelShape)shape, (VoxelShape)this.cubewest, (IBooleanFunction)IBooleanFunction.field_223244_o_);
                    break;
                }
            }
        }
        while (this.locked) {
            System.out.println("Wire bounding boxes locked. This should never happen!");
        }
        this.shapestates.put(checked, shape);
        if (shape == null) {
            return VoxelShapes.func_197880_a();
        }
        return shape;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState stateIn, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState acc = stateIn;
        for (Direction d : Direction.values()) {
            TileEntity facingTile = worldIn.func_175625_s(pos.func_177972_a(d));
            if (facingTile instanceof IMoltenSaltPipe) {
                acc = (BlockState)acc.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)EnumConnectType.WIRE);
                continue;
            }
            if ((!(facingTile instanceof TileMSRReactorCore) || d.func_176734_d() != Direction.UP) && (!(facingTile instanceof TileHeatExchanger) || d.func_176734_d() != Direction.DOWN)) continue;
            acc = (BlockState)acc.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)EnumConnectType.INVENTORY);
        }
        worldIn.func_175656_a(pos, acc);
    }

    @Deprecated
    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        TileEntity tile;
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof IMoltenSaltPipe) {
            ((IMoltenSaltPipe)tile).refreshNetwork();
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileEntity tile;
        super.onNeighborChange(state, world, pos, neighbor);
        if (!world.func_201670_d() && (tile = world.func_175625_s(pos)) instanceof IMoltenSaltPipe) {
            ((IMoltenSaltPipe)tile).refreshNetworkIfChange();
        }
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (stateIn.func_177229_b((Property)BlockStateProperties.field_208198_y) == Boolean.TRUE) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        EnumProperty<EnumConnectType> property = FACING_TO_PROPERTY_MAP.get(facing);
        TileEntity tile = world.func_175625_s(facingPos);
        if (tile instanceof IMoltenSaltPipe) {
            return (BlockState)stateIn.func_206870_a(property, (Comparable)EnumConnectType.WIRE);
        }
        if (tile instanceof TileMSRReactorCore && facing.func_176734_d() == Direction.UP || tile instanceof TileHeatExchanger && facing.func_176734_d() == Direction.DOWN) {
            return (BlockState)stateIn.func_206870_a(property, (Comparable)EnumConnectType.INVENTORY);
        }
        return (BlockState)stateIn.func_206870_a(property, (Comparable)EnumConnectType.NONE);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileMoltenSaltPipe();
    }
}

