/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.entity;

import electrodynamics.common.block.BlockGenericMachine;
import electrodynamics.prefab.utilities.object.Location;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.fusion.IElectromagnet;
import nuclearscience.api.radiation.RadiationSystem;
import nuclearscience.common.block.BlockElectromagneticBooster;
import nuclearscience.common.block.facing.FacingDirection;
import nuclearscience.common.tile.TileElectromagneticSwitch;
import nuclearscience.common.tile.TileParticleInjector;

public class EntityParticle
extends Entity {
    private static final DataParameter<Direction> DIRECTION = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187202_l);
    private static final DataParameter<Float> SPEED = EntityDataManager.func_187226_a(EntityParticle.class, (IDataSerializer)DataSerializers.field_187193_c);
    private Direction direction = Direction.UP;
    public float speed = 0.02f;
    public BlockPos source = BlockPos.field_177992_a;

    public EntityParticle(EntityType<?> entityTypeIn, World worldIn) {
        super((EntityType)DeferredRegisters.ENTITY_PARTICLE.get(), worldIn);
    }

    public EntityParticle(Direction direction, World worldIn, Location pos) {
        this((EntityType)DeferredRegisters.ENTITY_PARTICLE.get(), worldIn);
        this.func_226286_f_(pos.x(), pos.y(), pos.z());
        this.direction = direction;
        this.field_70158_ak = true;
        if (worldIn.field_72995_K) {
            EntityParticle.func_184227_b((double)4.0);
        }
    }

    public void func_70071_h_() {
        TileEntity tile = this.field_70170_p.func_175625_s(this.source);
        if (!this.field_70170_p.field_72995_K) {
            if (!(tile instanceof TileParticleInjector)) {
                this.func_70106_y();
                return;
            }
            ((TileParticleInjector)tile).addParticle(this);
            if (this.direction == null) {
                this.direction = Direction.UP;
            }
            this.field_70180_af.func_187227_b(DIRECTION, (Object)this.direction);
            this.field_70180_af.func_187227_b(SPEED, (Object)Float.valueOf(this.speed));
        } else if (!this.field_70180_af.func_187228_d()) {
            this.direction = (Direction)this.field_70180_af.func_187225_a(DIRECTION);
            this.speed = ((Float)this.field_70180_af.func_187225_a(SPEED)).floatValue();
        }
        Location source = new Location(this.func_233580_cy_());
        double totstrength = 1000.0;
        double range = 1.0;
        AxisAlignedBB bb = AxisAlignedBB.func_241550_g_((double)range, (double)range, (double)range);
        bb = bb.func_191194_a(new Vector3d(source.x(), source.y(), source.z()));
        List list = this.field_70170_p.func_217357_a(LivingEntity.class, bb);
        for (LivingEntity living : list) {
            RadiationSystem.applyRadiation(living, source, totstrength);
        }
        if (this.direction != null && this.direction != Direction.UP) {
            int checks = (int)(Math.ceil(this.speed) * 2.0);
            float localSpeed = this.speed / (float)checks;
            for (int i = 0; i < checks; ++i) {
                BlockPos positionNow;
                if (!this.field_70170_p.field_72995_K) {
                    TileParticleInjector injector = (TileParticleInjector)tile;
                    injector.checkCollision();
                }
                BlockPos next = this.func_233580_cy_();
                BlockState oldState = this.field_70170_p.func_180495_p(next);
                boolean isBooster = false;
                if (oldState.func_177230_c() == DeferredRegisters.blockElectromagneticBooster) {
                    Direction dir = ((Direction)oldState.func_177229_b((Property)BlockGenericMachine.FACING)).func_176734_d();
                    FacingDirection face = (FacingDirection)((Object)oldState.func_177229_b((Property)BlockElectromagneticBooster.FACINGDIRECTION));
                    if (face == FacingDirection.RIGHT) {
                        dir = dir.func_176746_e();
                    } else if (face == FacingDirection.LEFT) {
                        dir = dir.func_176735_f();
                    }
                    if (dir == this.direction) {
                        this.speed = (float)((double)this.speed + 0.0033333333333333335);
                    } else if (dir == this.direction.func_176734_d()) {
                        this.speed = (float)((double)this.speed - 0.02);
                    } else {
                        this.speed = (float)((double)this.speed + 0.0016666666666666668);
                        this.direction = dir;
                        Direction[] floor = this.func_233580_cy_();
                        this.func_70107_b((double)floor.func_177958_n() + 0.5, (double)floor.func_177956_o() + 0.5, (double)floor.func_177952_p() + 0.5);
                    }
                    isBooster = true;
                }
                if (this.speed < 0.0f) {
                    this.speed *= -1.0f;
                    this.direction = this.direction.func_176734_d();
                }
                this.func_70107_b(this.func_226277_ct_() + (double)((float)this.direction.func_82601_c() * localSpeed), this.func_226278_cu_(), this.func_226281_cx_() + (double)((float)this.direction.func_82599_e() * localSpeed));
                if (isBooster && this.field_70170_p.func_180495_p(positionNow = this.func_233580_cy_()).func_177230_c() == DeferredRegisters.blockElectromagneticSwitch) {
                    HashSet<Direction> directions = new HashSet<Direction>();
                    for (Direction dir : Direction.values()) {
                        if (dir == Direction.UP || dir == Direction.DOWN || dir == this.direction.func_176734_d() || this.field_70170_p.func_180495_p(positionNow.func_177972_a(dir)).func_177230_c() != Blocks.field_150350_a) continue;
                        directions.add(dir);
                    }
                    TileEntity te = this.field_70170_p.func_175625_s(positionNow);
                    if (te instanceof TileElectromagneticSwitch) {
                        TileElectromagneticSwitch switchte = (TileElectromagneticSwitch)te;
                        directions.remove(switchte.lastDirection);
                        if (directions.size() > (switchte.lastDirection == null ? 2 : 1)) {
                            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.speed, Explosion.Mode.DESTROY);
                            this.func_241204_bJ_();
                            break;
                        }
                        Iterator iterator = directions.iterator();
                        while (iterator.hasNext()) {
                            Direction dir;
                            switchte.lastDirection = dir = (Direction)iterator.next();
                            this.direction = dir;
                            this.func_70107_b((double)positionNow.func_177958_n() + 0.5, (double)positionNow.func_177956_o() + 0.5, (double)positionNow.func_177952_p() + 0.5);
                        }
                    }
                }
                if (this.field_70170_p.field_72995_K) continue;
                BlockPos getPos = this.func_233580_cy_();
                BlockState nextState = this.field_70170_p.func_180495_p(getPos);
                if (nextState.func_177230_c() == Blocks.field_150350_a || nextState.func_177230_c() == DeferredRegisters.blockElectromagneticSwitch) {
                    int amount = 0;
                    for (Direction of : Direction.values()) {
                        if (!(this.field_70170_p.func_180495_p(this.func_233580_cy_().func_177972_a(of)).func_177230_c() instanceof IElectromagnet)) continue;
                        ++amount;
                    }
                    if (amount < 4) {
                        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.speed, Explosion.Mode.DESTROY);
                        this.func_241204_bJ_();
                        break;
                    }
                    BlockState testNextBlock = this.field_70170_p.func_180495_p(getPos.func_177972_a(this.direction));
                    if (!(testNextBlock.func_177230_c() instanceof IElectromagnet) || testNextBlock.func_177230_c() == DeferredRegisters.blockElectromagneticSwitch) continue;
                    Direction checkRot = this.direction.func_176746_e();
                    testNextBlock = this.field_70170_p.func_180495_p(getPos.func_177972_a(checkRot));
                    if (testNextBlock.func_177230_c() == Blocks.field_150350_a || testNextBlock.func_177230_c() == DeferredRegisters.blockElectromagneticSwitch) {
                        BlockPos floor = this.func_233580_cy_();
                        this.direction = checkRot;
                        this.func_70107_b((double)floor.func_177958_n() + 0.5, (double)floor.func_177956_o() + 0.5, (double)floor.func_177952_p() + 0.5);
                        continue;
                    }
                    checkRot = this.direction.func_176746_e().func_176734_d();
                    testNextBlock = this.field_70170_p.func_180495_p(getPos.func_177972_a(checkRot));
                    if (testNextBlock.func_177230_c() == Blocks.field_150350_a || testNextBlock.func_177230_c() == DeferredRegisters.blockElectromagneticSwitch) {
                        BlockPos floor = this.func_233580_cy_();
                        this.direction = checkRot;
                        this.func_70107_b((double)floor.func_177958_n() + 0.5, (double)floor.func_177956_o() + 0.5, (double)floor.func_177952_p() + 0.5);
                        continue;
                    }
                    this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.speed, Explosion.Mode.DESTROY);
                    this.func_241204_bJ_();
                    break;
                }
                boolean checkIsBooster = nextState.func_177230_c() == DeferredRegisters.blockElectromagneticBooster && oldState.func_177230_c() == DeferredRegisters.blockElectromagneticBooster;
                boolean explode = false;
                if (checkIsBooster) {
                    Direction nextDir;
                    Direction oldDir = (Direction)oldState.func_177229_b((Property)BlockGenericMachine.FACING);
                    if (oldDir != (nextDir = (Direction)nextState.func_177229_b((Property)BlockGenericMachine.FACING))) {
                        FacingDirection face = (FacingDirection)((Object)oldState.func_177229_b((Property)BlockElectromagneticBooster.FACINGDIRECTION));
                        if (face == FacingDirection.RIGHT) {
                            oldDir = oldDir.func_176746_e();
                        } else if (face == FacingDirection.LEFT) {
                            oldDir = oldDir.func_176735_f();
                        }
                        if (oldDir != nextDir) {
                            explode = true;
                        }
                    }
                } else if (nextState.func_177230_c() != DeferredRegisters.blockElectromagneticBooster) {
                    explode = true;
                }
                if (!explode) continue;
                this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.speed, Explosion.Mode.DESTROY);
                this.func_241204_bJ_();
                break;
            }
            this.speed = Math.min(this.speed, 1.999f);
        } else if (this.field_70173_aa > 100) {
            this.func_241204_bJ_();
        }
    }

    protected void func_70088_a() {
        if (this.direction == null) {
            this.direction = Direction.UP;
        }
        this.field_70180_af.func_187214_a(DIRECTION, (Object)this.direction);
        this.field_70180_af.func_187214_a(SPEED, (Object)Float.valueOf(this.speed));
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.source = new BlockPos(compound.func_74762_e("sourceX"), compound.func_74762_e("sourceY"), compound.func_74762_e("sourceZ"));
    }

    public ITextComponent func_200200_C_() {
        return new StringTextComponent("entity.particle");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("sourceX", this.source.func_177958_n());
        compound.func_74768_a("sourceY", this.source.func_177956_o());
        compound.func_74768_a("sourceZ", this.source.func_177952_p());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

