/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.packet;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import nuclearscience.common.tile.TileQuantumCapacitor;

public class PacketSetQuantumCapacitorData {
    private final double outputJoules;
    private final int frequency;
    private final BlockPos pos;

    public PacketSetQuantumCapacitorData(BlockPos pos, double outputJoules, int frequency) {
        this.pos = pos;
        this.outputJoules = outputJoules;
        this.frequency = frequency;
    }

    public static void handle(PacketSetQuantumCapacitorData message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            TileQuantumCapacitor tile;
            ServerWorld world = ((NetworkEvent.Context)context.get()).getSender().func_71121_q();
            if (world != null && (tile = (TileQuantumCapacitor)world.func_175625_s(message.pos)) != null) {
                tile.outputJoules = message.outputJoules;
                tile.frequency = message.frequency;
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketSetQuantumCapacitorData pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.writeDouble(pkt.outputJoules);
        buf.writeInt(pkt.frequency);
    }

    public static PacketSetQuantumCapacitorData decode(PacketBuffer buf) {
        return new PacketSetQuantumCapacitorData(buf.func_179259_c(), buf.readDouble(), buf.readInt());
    }
}

