/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tile.TilePlasma;

public class TileFusionReactorCore
extends GenericTileTicking {
    public int deuterium;
    public int tritium;
    private int timeLeft = 0;

    public TileFusionReactorCore() {
        super((TileEntityType)DeferredRegisters.TILE_FUSIONREACTORCORE.get());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).input(Direction.DOWN).input(Direction.UP).maxJoules(Constants.FUSIONREACTOR_USAGE_PER_TICK * 20.0).voltage(480.0));
    }

    public void tickServer(ComponentTickable tick) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic);
        if (this.field_145850_b.func_72912_H().func_76073_f() % 20L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        }
        if (this.tritium > 0 && this.deuterium > 0 && this.timeLeft <= 0 && electro.getJoulesStored() > Constants.FUSIONREACTOR_USAGE_PER_TICK) {
            --this.deuterium;
            --this.tritium;
            this.timeLeft = 300;
        }
        if (this.timeLeft > 0 && electro.getJoulesStored() > Constants.FUSIONREACTOR_USAGE_PER_TICK) {
            for (Direction dir : Direction.values()) {
                if (dir == Direction.UP || dir == Direction.DOWN) continue;
                BlockPos offset = this.field_174879_c.func_177972_a(dir);
                BlockState state = this.field_145850_b.func_180495_p(offset);
                if (state.func_177230_c() == DeferredRegisters.blockPlasma) {
                    TileEntity tile = this.field_145850_b.func_175625_s(offset);
                    if (!(tile instanceof TilePlasma) || ((TilePlasma)tile).ticksExisted <= 30) continue;
                    ((TilePlasma)tile).ticksExisted = 0;
                    continue;
                }
                if (state.func_177230_c() != Blocks.field_150350_a) continue;
                this.field_145850_b.func_175656_a(offset, DeferredRegisters.blockPlasma.func_176223_P());
            }
            electro.joules(electro.getJoulesStored() - Constants.FUSIONREACTOR_USAGE_PER_TICK);
        }
        --this.timeLeft;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeCustomPacket(compound);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.readCustomPacket(compound);
    }

    public void writeCustomPacket(CompoundNBT nbt) {
        nbt.func_74768_a("deuterium", this.deuterium);
        nbt.func_74768_a("tritium", this.tritium);
    }

    public void readCustomPacket(CompoundNBT nbt) {
        this.deuterium = nbt.func_74762_e("deuterium");
        this.tritium = nbt.func_74762_e("tritium");
    }
}

