/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.api.sound.SoundAPI;
import electrodynamics.common.item.ItemProcessorUpgrade;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentDirection;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentFluidHandlerMulti;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentProcessor;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import nuclearscience.DeferredRegisters;
import nuclearscience.SoundRegister;
import nuclearscience.common.inventory.container.ContainerGasCentrifuge;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tags.NuclearScienceTags;

public class TileGasCentrifuge
extends GenericTileTicking {
    public static final int TANKCAPACITY = 5000;
    public static final float REQUIRED = 2500.0f;
    public int stored235 = 0;
    public int stored238 = 0;
    public int spinSpeed;

    public TileGasCentrifuge() {
        super((TileEntityType)DeferredRegisters.TILE_GASCENTRIFUGE.get());
        this.addComponent((Component)new ComponentTickable().tickClient(this::tickClient));
        this.addComponent((Component)new ComponentDirection());
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket));
        this.addComponent((Component)new ComponentFluidHandlerMulti((GenericTile)this).addFluidTank(NuclearScienceTags.Fluids.URANIUM_HEXAFLUORIDE, 5000, true).relativeInput(new Direction[]{Direction.NORTH}));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(240.0).input(Direction.DOWN).maxJoules(Constants.GASCENTRIFUGE_USAGE_PER_TICK * 10.0));
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(5).faceSlots(Direction.DOWN, new Integer[]{0, 1}).relativeFaceSlots(Direction.WEST, new Integer[]{0, 1}).valid((slot, stack) -> slot < 2 || stack.func_77973_b() instanceof ItemProcessorUpgrade));
        this.addComponent((Component)new ComponentProcessor((GenericTile)this).upgradeSlots(new int[]{2, 3, 4}).usage(Constants.GASCENTRIFUGE_USAGE_PER_TICK).requiredTicks((long)Constants.GASCENTRIFUGE_REQUIRED_TICKS_PER_PROCESSING).canProcess(this::canProcess).process(this::process));
        this.addComponent((Component)new ComponentContainerProvider("container.gascentrifuge").createMenu((id, player) -> new ContainerGasCentrifuge((int)id, (PlayerInventory)player, (IInventory)this.getComponent(ComponentType.Inventory), (IIntArray)this.getCoordsArray())));
    }

    public boolean canProcess(ComponentProcessor processor) {
        boolean val;
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic);
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        ComponentFluidHandlerMulti tank = (ComponentFluidHandlerMulti)this.getComponent(ComponentType.FluidHandler);
        boolean hasFluid = false;
        for (Fluid fluid : NuclearScienceTags.Fluids.URANIUM_HEXAFLUORIDE.func_230236_b_()) {
            FluidTank fTank = tank.getTankFromFluid(fluid, true);
            if (!((double)fTank.getFluidAmount() >= 41.666666666666664)) continue;
            hasFluid = true;
            break;
        }
        boolean bl = val = electro.getJoulesStored() >= processor.getUsage() && hasFluid && inv.func_70301_a(0).func_190916_E() < inv.func_70301_a(0).func_77976_d() && inv.func_70301_a(1).func_190916_E() < inv.func_70301_a(1).func_77976_d();
        if (!val && this.spinSpeed > 0) {
            this.spinSpeed = 0;
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        }
        return val;
    }

    public void process(ComponentProcessor processor) {
        ItemStack stack;
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        ComponentFluidHandlerMulti tank = (ComponentFluidHandlerMulti)this.getComponent(ComponentType.FluidHandler);
        this.spinSpeed = (int)processor.operatingSpeed;
        ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        int processed = 41;
        for (Fluid fluid : NuclearScienceTags.Fluids.URANIUM_HEXAFLUORIDE.func_230236_b_()) {
            FluidTank fTank = tank.getTankFromFluid(fluid, true);
            if (fTank.getFluidAmount() < processed) continue;
            fTank.getFluid().shrink(processed);
            break;
        }
        this.stored235 = (int)((double)this.stored235 + (double)processed * 0.172);
        this.stored238 = (int)((double)this.stored238 + (double)processed * 0.8280000000000001);
        if ((float)this.stored235 > 2500.0f) {
            stack = inv.func_70301_a(0);
            if (!stack.func_190926_b()) {
                stack.func_190920_e(stack.func_190916_E() + 1);
            } else {
                inv.func_70299_a(0, new ItemStack((IItemProvider)DeferredRegisters.ITEM_URANIUM235.get()));
            }
            this.stored235 -= 2500;
        }
        if ((float)this.stored238 > 2500.0f) {
            stack = inv.func_70301_a(1);
            if (!stack.func_190926_b()) {
                stack.func_190920_e(stack.func_190916_E() + 1);
            } else {
                inv.func_70299_a(1, new ItemStack((IItemProvider)DeferredRegisters.ITEM_URANIUM238.get()));
            }
            this.stored238 -= 2500;
        }
    }

    protected void tickClient(ComponentTickable tickable) {
        if (this.spinSpeed > 0 && tickable.getTicks() % 80L == 0L) {
            SoundAPI.playSound((SoundEvent)((SoundEvent)SoundRegister.SOUND_GASCENTRIFUGE.get()), (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, (float)1.0f, (BlockPos)this.field_174879_c);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("stored235", this.stored235);
        compound.func_74768_a("stored238", this.stored238);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.stored235 = compound.func_74762_e("stored235");
        this.stored238 = compound.func_74762_e("stored238");
    }

    public void writeCustomPacket(CompoundNBT tag) {
        tag.func_74768_a("spinSpeed", this.spinSpeed);
        tag.func_74768_a("stored235", this.stored235);
        tag.func_74768_a("stored238", this.stored238);
    }

    public void readCustomPacket(CompoundNBT nbt) {
        this.spinSpeed = nbt.func_74762_e("spinSpeed");
        this.stored235 = nbt.func_74762_e("stored235");
        this.stored238 = nbt.func_74762_e("stored238");
    }
}

