/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tile.TileTurbine;

public class TileHeatExchanger
extends GenericTileTicking {
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private TileTurbine[][][] cachedTurbines = new TileTurbine[5][2][5];
    private double temperature;

    public TileHeatExchanger() {
        super((TileEntityType)DeferredRegisters.TILE_HEATEXCHANGER.get());
        this.addComponent((Component)new ComponentTickable().tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket).guiPacketReader(this::readCustomPacket).guiPacketWriter(this::writeCustomPacket));
    }

    protected void tickServer(ComponentTickable tickable) {
        if (tickable.getTicks() % 10L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        if (this.temperature > 100.0) {
            this.produceSteam();
        }
        this.temperature *= 0.9;
    }

    protected void produceSteam() {
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    int offsetZ;
                    int offsetY;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.field_145850_b.field_72995_K || !((double)this.field_145850_b.field_73012_v.nextFloat() < this.temperature / 900000.0) || !this.field_145850_b.func_180495_p(this.field_174879_c).func_235901_b_((Property)BlockStateProperties.field_208198_y)) continue;
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.field_174879_c.func_177958_n() + i - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY = this.field_174879_c.func_177956_o() + j, offsetZ = this.field_174879_c.func_177952_p() + k - 2);
                    Block offset = this.field_145850_b.func_180495_p(offpos).func_177230_c();
                    if (offset != Blocks.field_150355_j) continue;
                    boolean bl2 = isFaceWater = this.field_145850_b.func_180495_p(new BlockPos(offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())).func_177230_c() == Blocks.field_150355_j || this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), offsetZ)).func_177230_c() == Blocks.field_150355_j || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        TileTurbine turbine = this.cachedTurbines[i][j][k];
                        if (turbine != null) {
                            if (turbine.func_145837_r()) {
                                this.cachedTurbines[i][j][k] = null;
                            }
                            turbine.addSteam((int)(Constants.MSRREACTOR_MAXENERGYTARGET / (500.0 * (900.0 / this.temperature))), (int)this.temperature);
                        }
                        if ((double)this.field_145850_b.field_73012_v.nextFloat() < this.temperature / 900000.0) {
                            this.field_145850_b.func_175656_a(offpos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (turbine != null && !this.field_145850_b.field_147482_g.contains((Object)turbine)) continue;
                        TileEntity above = this.field_145850_b.func_175625_s(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        if (above instanceof TileTurbine) {
                            this.cachedTurbines[i][j][k] = (TileTurbine)above;
                            continue;
                        }
                        this.cachedTurbines[i][j][k] = null;
                        continue;
                    }
                    if (!this.field_145850_b.field_72995_K || !((double)this.field_145850_b.field_73012_v.nextFloat() < this.temperature / 2700.0)) continue;
                    double offsetFX = (double)offsetX + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197612_e, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.field_145850_b.field_73012_v.nextInt(3) != 0) continue;
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void writeCustomPacket(CompoundNBT tag) {
        tag.func_74780_a("temperature", this.temperature);
    }

    protected void readCustomPacket(CompoundNBT nbt) {
        this.temperature = nbt.func_74769_h("temperature");
    }

    public Double receiveHeat(Double perReceiver) {
        this.temperature = perReceiver;
        return perReceiver;
    }
}

