/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentDirection;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.Location;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.network.moltensalt.IMoltenSaltPipe;
import nuclearscience.api.radiation.RadiationSystem;
import nuclearscience.common.inventory.container.ContainerMSRReactorCore;
import nuclearscience.common.network.MoltenSaltNetwork;
import nuclearscience.common.tile.TileControlRodAssembly;
import nuclearscience.common.tile.TileFreezePlug;

public class TileMSRReactorCore
extends GenericTileTicking {
    public static final int MELTDOWN_TEMPERATURE = 900;
    public static final double FUEL_CAPACITY = 1000.0;
    public static final double FUEL_USAGE_RATE = 0.01;
    public double temperature = 15.0;
    public int ticksOverheating = 0;
    public double currentFuel = 0.0;
    private CachedTileOutput outputCache;
    public CachedTileOutput plugCache;

    public TileMSRReactorCore() {
        super((TileEntityType)DeferredRegisters.TILE_MSRREACTORCORE.get());
        this.addComponent((Component)new ComponentDirection());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket).guiPacketReader(this::readCustomPacket).guiPacketWriter(this::writeCustomPacket));
        this.addComponent((Component)new ComponentContainerProvider("container.msrreactorcore").createMenu((id, player) -> new ContainerMSRReactorCore((int)id, (PlayerInventory)player, null, (IIntArray)this.getCoordsArray())));
    }

    protected void writeCustomPacket(CompoundNBT tag) {
        tag.func_74780_a("temperature", this.temperature);
        tag.func_74780_a("currentFuel", this.currentFuel);
    }

    protected void readCustomPacket(CompoundNBT nbt) {
        this.temperature = nbt.func_74769_h("temperature");
        this.currentFuel = nbt.func_74769_h("currentFuel");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeCustomPacket(compound);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.readCustomPacket(compound);
        super.func_230337_a_(state, compound);
    }

    protected void tickServer(ComponentTickable tick) {
        double change;
        if (this.outputCache == null) {
            this.outputCache = new CachedTileOutput(this.field_145850_b, new BlockPos((Vector3i)this.field_174879_c).func_177972_a(Direction.UP));
        }
        if (this.plugCache == null) {
            this.plugCache = new CachedTileOutput(this.field_145850_b, new BlockPos((Vector3i)this.field_174879_c).func_177972_a(Direction.DOWN));
        }
        if (tick.getTicks() % 40L == 0L) {
            this.outputCache.update();
            this.plugCache.update();
        }
        if ((change = (this.temperature - 15.0) / 3000.0 + (this.temperature - 15.0) / 5000.0) != 0.0) {
            this.temperature -= change < 0.001 && change > 0.0 ? 0.001 : (change > -0.001 && change < 0.0 ? -0.001 : change);
        }
        if (this.plugCache.valid() && this.plugCache.getSafe() instanceof TileFreezePlug && ((TileFreezePlug)((Object)this.plugCache.getSafe())).isFrozen() && this.currentFuel > 0.01) {
            int insertion = 0;
            for (Direction dir : Direction.values()) {
                TileEntity tile;
                if (dir == Direction.UP || dir == Direction.DOWN || !((tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(dir))) instanceof TileControlRodAssembly)) continue;
                TileControlRodAssembly control = (TileControlRodAssembly)tile;
                if (control.dir != dir.func_176734_d()) continue;
                insertion += control.insertion;
            }
            if (this.field_145850_b.func_72912_H().func_82573_f() % 10L == 0L) {
                Location source = new Location((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
                double totstrength = this.temperature * Math.pow(3.0, Math.pow(this.temperature / 900.0, 9.0));
                double range = Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0;
                AxisAlignedBB bb = AxisAlignedBB.func_241550_g_((double)range, (double)range, (double)range);
                bb = bb.func_191194_a(new Vector3d(source.x(), source.y(), source.z()));
                List list = this.field_145850_b.func_217357_a(LivingEntity.class, bb);
                for (LivingEntity living : list) {
                    RadiationSystem.applyRadiation(living, source, totstrength);
                }
            }
            double insertDecimal = (double)(100 - insertion) / 100.0;
            this.currentFuel -= Math.min(this.currentFuel, 0.01 * insertDecimal * Math.pow(2.0, Math.pow(this.temperature / 800.0, 4.0)));
            this.temperature += (900.0 * insertDecimal * (1.2 + this.field_145850_b.field_73012_v.nextDouble() / 5.0) - this.temperature) / 200.0;
            if (this.outputCache.valid() && this.outputCache.getSafe() instanceof IMoltenSaltPipe) {
                MoltenSaltNetwork net = (MoltenSaltNetwork)((IMoltenSaltPipe)this.outputCache.getSafe()).getNetwork();
                net.emit(this.temperature, new ArrayList<TileEntity>(), false);
            }
        }
        if (tick.getTicks() % 5L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendGuiPacketToTracking();
        }
    }

    protected void tickClient(ComponentTickable tick) {
        if (this.plugCache == null) {
            this.plugCache = new CachedTileOutput(this.field_145850_b, new BlockPos((Vector3i)this.field_174879_c).func_177972_a(Direction.DOWN));
        }
    }
}

