/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.Location;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.radiation.RadiationSystem;

public class TileMeltedReactor
extends GenericTileTicking {
    public static final float RADIATION_RADIUS = 30.0f;
    public static final float START_RADIATION = 4.383E7f;
    public int radiation = 43830000;
    public int temperature = 6000;

    public TileMeltedReactor() {
        super((TileEntityType)DeferredRegisters.TILE_MELTEDREACTOR.get());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
    }

    protected void tickServer(ComponentTickable tickable) {
        Block block;
        BlockState st;
        BlockPos p;
        double distanceSq;
        double d5;
        double d4;
        double d3;
        double z2;
        double y2;
        BlockState state;
        long ticks = tickable.getTicks();
        if (ticks % 3L == 0L && ((state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b())).func_185904_a() == Material.field_151579_a || state.func_177230_c() instanceof FlowingFluidBlock)) {
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), this.func_195044_w());
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (tile instanceof TileMeltedReactor) {
                TileMeltedReactor newTile = (TileMeltedReactor)tile;
                newTile.radiation = this.radiation;
                newTile.radiation = this.radiation;
            }
            return;
        }
        if (this.temperature > 0) {
            --this.temperature;
            double x2 = (double)this.field_174879_c.func_177958_n() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.field_174879_c.func_177956_o() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.field_174879_c.func_177952_p() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.field_174879_c.func_177958_n() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.field_174879_c.func_177956_o() - y2) * d4 + (d5 = (double)this.field_174879_c.func_177952_p() - z2) * d5;
            if (distanceSq < 900.0 && this.field_145850_b.field_73012_v.nextDouble() > distanceSq / 900.0) {
                p = new BlockPos(Math.floor(x2), Math.floor(y2), Math.floor(z2));
                st = this.field_145850_b.func_180495_p(p);
                block = st.func_177230_c();
                if (st.func_185904_a() == Material.field_151579_a) {
                    if (this.field_145850_b.func_180495_p(p.func_177977_b()).func_185904_a() != Material.field_151579_a) {
                        this.field_145850_b.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
                    }
                } else if (block == Blocks.field_150348_b) {
                    if (this.temperature > 2100) {
                        this.field_145850_b.func_175656_a(p, Blocks.field_150347_e.func_176223_P());
                    }
                } else if (block == Blocks.field_150347_e) {
                    this.field_145850_b.func_175656_a(p, Blocks.field_150353_l.func_176223_P());
                } else if (block == Blocks.field_150355_j) {
                    this.field_145850_b.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
                } else if (block == Blocks.field_150354_m) {
                    this.field_145850_b.func_175656_a(p, Blocks.field_150359_w.func_176223_P());
                }
            }
        }
        if (this.radiation > 0) {
            --this.radiation;
            double x2 = (double)this.field_174879_c.func_177958_n() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            y2 = (double)this.field_174879_c.func_177956_o() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            z2 = (double)this.field_174879_c.func_177952_p() + 0.5 + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 30.0 / 2.0;
            d3 = (double)this.field_174879_c.func_177958_n() - x2;
            distanceSq = d3 * d3 + (d4 = (double)this.field_174879_c.func_177956_o() - y2) * d4 + (d5 = (double)this.field_174879_c.func_177952_p() - z2) * d5;
            if (distanceSq < 900.0 && this.field_145850_b.field_73012_v.nextDouble() > distanceSq / 900.0 && ((block = (st = this.field_145850_b.func_180495_p(p = new BlockPos(Math.floor(x2), Math.floor(y2), Math.floor(z2)))).func_177230_c()) == Blocks.field_196658_i || block == Blocks.field_150346_d)) {
                this.field_145850_b.func_175656_a(p, DeferredRegisters.blockRadioactiveSoil.func_176223_P());
            }
        }
        if (this.field_145850_b.func_72912_H().func_82573_f() % 10L == 0L) {
            Location source = new Location((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
            double totstrength = 120000.0f * ((float)this.radiation / 4.383E7f);
            double range = Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0;
            AxisAlignedBB bb = AxisAlignedBB.func_241550_g_((double)range, (double)range, (double)range);
            bb = bb.func_191194_a(new Vector3d(source.x(), source.y(), source.z()));
            List list = this.field_145850_b.func_217357_a(LivingEntity.class, bb);
            for (LivingEntity living : list) {
                RadiationSystem.applyRadiation(living, source, totstrength);
            }
        }
    }
}

