/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentDirection;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentProcessor;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.Location;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.entity.EntityParticle;
import nuclearscience.common.inventory.container.ContainerParticleInjector;
import nuclearscience.common.settings.Constants;

public class TileParticleInjector
extends GenericTileTicking {
    private EntityParticle[] particles = new EntityParticle[2];
    private long timeSinceSpawn = 0L;

    public TileParticleInjector() {
        super((TileEntityType)DeferredRegisters.TILE_PARTICLEINJECTOR.get());
        this.addComponent((Component)new ComponentTickable());
        this.addComponent((Component)new ComponentDirection());
        this.addComponent((Component)new ComponentPacketHandler());
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(3).valid((index, stack) -> index != 1 || stack.func_77973_b() == DeferredRegisters.ITEM_CELLELECTROMAGNETIC.get()).relativeFaceSlots(Direction.UP, new Integer[]{0, 1}).relativeFaceSlots(Direction.WEST, new Integer[]{0, 1}).relativeSlotFaces(Integer.valueOf(2), new Direction[]{Direction.DOWN, Direction.EAST}));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(960.0).relativeInput(Direction.NORTH).maxJoules(Constants.PARTICLEINJECTOR_USAGE_PER_PARTICLE * 10.0));
        this.addComponent((Component)new ComponentProcessor((GenericTile)this).canProcess(this::canProcess).usage(Constants.PARTICLEINJECTOR_USAGE_PER_PARTICLE).process(this::process));
        this.addComponent((Component)new ComponentContainerProvider("container.particleinjector").createMenu((id, player) -> new ContainerParticleInjector((int)id, (PlayerInventory)player, (IInventory)this.getComponent(ComponentType.Inventory), (IIntArray)this.getCoordsArray())));
    }

    protected boolean canProcess(ComponentProcessor processor) {
        if (this.particles[0] != null && !this.particles[0].func_70089_S()) {
            this.particles[0] = null;
        }
        if (this.particles[1] != null && !this.particles[1].func_70089_S()) {
            this.particles[1] = null;
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        ItemStack resultStack = inv.func_70301_a(2);
        --this.timeSinceSpawn;
        boolean isItem = false;
        ItemStack inputItem = inv.func_70301_a(0);
        if (inputItem != null && !inputItem.equals(new ItemStack((IItemProvider)Items.field_190931_a), true)) {
            isItem = true;
        }
        return this.timeSinceSpawn < 0L && isItem && (this.particles[0] == null || this.particles[1] == null) && inv.func_70301_a(0).func_190916_E() > 0 && resultStack.func_190916_E() < resultStack.func_77976_d();
    }

    public void checkCollision() {
        EntityParticle two;
        EntityParticle one;
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        ItemStack resultStack = inv.func_70301_a(2);
        ItemStack cellStack = inv.func_70301_a(1);
        if (resultStack.func_190916_E() < resultStack.func_77976_d() && cellStack.func_190916_E() > 0 && this.particles[0] != null && this.particles[1] != null && (one = this.particles[0]).func_70032_d(two = this.particles[1]) < 1.0f) {
            double speedOfMax = Math.pow((double)(one.speed + two.speed) / 4.0, 2.0);
            one.func_70106_y();
            two.func_70106_y();
            this.particles[1] = null;
            this.particles[0] = null;
            cellStack.func_190918_g(1);
            double mod = this.field_145850_b.field_73012_v.nextDouble();
            if (speedOfMax > 0.999) {
                if (resultStack.func_77973_b() == DeferredRegisters.ITEM_CELLDARKMATTER.get()) {
                    resultStack.func_190920_e(resultStack.func_190916_E() + 1);
                } else if (resultStack.func_190926_b()) {
                    inv.func_70299_a(2, new ItemStack((IItemProvider)DeferredRegisters.ITEM_CELLDARKMATTER.get()));
                }
            } else if (speedOfMax > mod) {
                if (resultStack.func_77973_b() == DeferredRegisters.ITEM_CELLANTIMATTERSMALL.get()) {
                    resultStack.func_190920_e(resultStack.func_190916_E() + 1);
                } else if (resultStack.func_190926_b()) {
                    inv.func_70299_a(2, new ItemStack((IItemProvider)DeferredRegisters.ITEM_CELLANTIMATTERSMALL.get()));
                }
            }
        }
    }

    public void process(ComponentProcessor processor) {
        this.timeSinceSpawn = 100L;
        Direction dir = ((ComponentDirection)this.getComponent(ComponentType.Direction)).getDirection();
        ItemStack stack = processor.getInput();
        stack.func_190920_e(stack.func_190916_E() - 1);
        EntityParticle particle = new EntityParticle(dir, this.field_145850_b, new Location((double)((float)this.field_174879_c.func_177958_n() + 0.5f + (float)dir.func_82601_c() * 1.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f + (float)dir.func_96559_d() * 1.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f + (float)dir.func_82599_e() * 1.5f)));
        this.addParticle(particle);
        this.field_145850_b.func_217376_c((Entity)particle);
    }

    public void addParticle(EntityParticle particle) {
        if (this.particles[0] != particle && this.particles[1] != particle) {
            particle.source = this.func_174877_v();
            if (this.particles[0] == null) {
                this.particles[0] = particle;
            } else if (this.particles[1] == null) {
                this.particles[1] = particle;
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

