/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.common.network.ElectricityUtilities;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.TransferPack;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import nuclearscience.DeferredRegisters;
import nuclearscience.common.inventory.container.ContainerQuantumCapacitor;
import nuclearscience.common.world.QuantumCapacitorData;

public class TileQuantumCapacitor
extends GenericTileTicking
implements IEnergyStorage {
    public static final double DEFAULT_MAX_JOULES = Double.MAX_VALUE;
    public static final double DEFAULT_VOLTAGE = 1920.0;
    public double outputJoules = 359.0;
    public int frequency = 0;
    public UUID uuid = UUID.randomUUID();
    private CachedTileOutput outputCache;
    private CachedTileOutput outputCache2;
    public double joulesClient = 0.0;
    private Direction lastDir = null;

    public TileQuantumCapacitor() {
        super((TileEntityType)DeferredRegisters.TILE_QUANTUMCAPACITOR.get());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler().guiPacketReader(this::readGUIPacket).guiPacketWriter(this::writeGUIPacket));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(1920.0).output(Direction.DOWN).output(Direction.UP).input(Direction.WEST).input(Direction.EAST).input(Direction.SOUTH).input(Direction.NORTH).receivePower(this::receivePower).setJoules(this::setJoulesStored).getJoules(this::getJoulesStored));
        this.addComponent((Component)new ComponentInventory((GenericTile)this));
        this.addComponent((Component)new ComponentContainerProvider("container.quantumcapacitor").createMenu((id, player) -> new ContainerQuantumCapacitor((int)id, (PlayerInventory)player, (IInventory)this.getComponent(ComponentType.Inventory), (IIntArray)this.getCoordsArray())));
    }

    public double getOutputJoules() {
        return this.outputJoules;
    }

    public void tickServer(ComponentTickable tickable) {
        double sent;
        double joules;
        if (this.outputCache == null) {
            this.outputCache = new CachedTileOutput(this.field_145850_b, new BlockPos((Vector3i)this.field_174879_c).func_177972_a(Direction.UP));
        }
        if (this.outputCache2 == null) {
            this.outputCache2 = new CachedTileOutput(this.field_145850_b, new BlockPos((Vector3i)this.field_174879_c).func_177972_a(Direction.DOWN));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.outputCache.update();
            this.outputCache2.update();
        }
        if ((joules = this.getJoulesStored()) > 0.0 && this.outputCache.valid()) {
            sent = ElectricityUtilities.receivePower((TileEntity)((TileEntity)this.outputCache.getSafe()), (Direction)Direction.DOWN, (TransferPack)TransferPack.joulesVoltage((double)Math.min(joules, this.outputJoules), (double)1920.0), (boolean)false).getJoules();
            QuantumCapacitorData.get(this.field_145850_b).setJoules(this.uuid, this.frequency, this.getJoulesStored() - sent);
        }
        if ((joules = this.getJoulesStored()) > 0.0 && this.outputCache2.valid()) {
            sent = ElectricityUtilities.receivePower((TileEntity)((TileEntity)this.outputCache2.getSafe()), (Direction)Direction.UP, (TransferPack)TransferPack.joulesVoltage((double)Math.min(joules, this.outputJoules), (double)1920.0), (boolean)false).getJoules();
            QuantumCapacitorData.get(this.field_145850_b).setJoules(this.uuid, this.frequency, this.getJoulesStored() - sent);
        }
        if (tickable.getTicks() % 50L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendGuiPacketToTracking();
        }
    }

    public void writeGUIPacket(CompoundNBT nbt) {
        nbt.func_74780_a("joulesClient", this.getJoulesStored());
        nbt.func_74768_a("frequency", this.frequency);
        nbt.func_186854_a("uuid", this.uuid);
        nbt.func_74780_a("outputJoules", this.outputJoules);
    }

    public void readGUIPacket(CompoundNBT nbt) {
        this.joulesClient = nbt.func_74769_h("joulesClient");
        this.frequency = nbt.func_74762_e("frequency");
        this.uuid = nbt.func_186857_a("uuid");
        this.outputJoules = nbt.func_74769_h("outputJoules");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("frequency", this.frequency);
        compound.func_74780_a("outputJoules", this.outputJoules);
        compound.func_186854_a("uuid", this.uuid);
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.outputJoules = compound.func_74769_h("outputJoules");
        this.frequency = compound.func_74762_e("frequency");
        if (compound.func_186855_b("uuid")) {
            this.uuid = compound.func_186857_a("uuid");
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            this.lastDir = facing;
            return LazyOptional.of(() -> this);
        }
        return super.getCapability(capability, facing);
    }

    public TransferPack receivePower(TransferPack transfer, boolean debug) {
        double joules = this.getJoulesStored();
        if (this.lastDir != Direction.UP && this.lastDir != Direction.DOWN) {
            double received = Math.min(Math.min(Double.MAX_VALUE, transfer.getJoules()), Double.MAX_VALUE - joules);
            if (!debug) {
                if (transfer.getVoltage() == 1920.0) {
                    joules += received;
                }
                QuantumCapacitorData.get(this.field_145850_b).setJoules(this.uuid, this.frequency, joules);
                if (transfer.getVoltage() > 1920.0) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                    this.field_145850_b.func_217385_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (float)Math.log10(10.0 + transfer.getVoltage() / 1920.0), Explosion.Mode.DESTROY);
                    return TransferPack.EMPTY;
                }
            }
            return TransferPack.joulesVoltage((double)received, (double)transfer.getVoltage());
        }
        return TransferPack.EMPTY;
    }

    @Deprecated
    public int receiveEnergy(int maxReceive, boolean simulate) {
        int calVoltage = 120;
        TransferPack pack = this.receivePower(TransferPack.joulesVoltage((double)maxReceive, (double)calVoltage), simulate);
        return (int)Math.min(2.147483647E9, pack.getJoules());
    }

    @Deprecated
    public int extractEnergy(int maxExtract, boolean simulate) {
        int calVoltage = 120;
        TransferPack pack = ((ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic)).extractPower(TransferPack.joulesVoltage((double)maxExtract, (double)calVoltage), simulate);
        return (int)Math.min(2.147483647E9, pack.getJoules());
    }

    @Deprecated
    public int getEnergyStored() {
        return (int)Math.min(2.147483647E9, this.getJoulesStored());
    }

    @Deprecated
    public int getMaxEnergyStored() {
        return (int)Math.min(2.147483647E9, Double.MAX_VALUE);
    }

    @Deprecated
    public boolean canExtract() {
        return true;
    }

    @Deprecated
    public boolean canReceive() {
        return true;
    }

    public void setJoulesStored(double joules) {
        QuantumCapacitorData data = QuantumCapacitorData.get(this.field_145850_b);
        if (data != null) {
            data.setJoules(this.uuid, this.frequency, joules);
        }
    }

    public double getJoulesStored() {
        QuantumCapacitorData data = QuantumCapacitorData.get(this.field_145850_b);
        return data == null ? 0.0 : data.getJoules(this.uuid, this.frequency);
    }

    public double getMaxJoulesStored() {
        return Double.MAX_VALUE;
    }
}

