/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.common.network.ElectricityUtilities;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.TransferPack;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.radiation.IRadioactiveObject;
import nuclearscience.api.radiation.RadiationRegister;
import nuclearscience.common.inventory.container.ContainerRadioisotopeGenerator;
import nuclearscience.common.settings.Constants;

public class TileRadioisotopeGenerator
extends GenericTileTicking {
    protected CachedTileOutput output1;
    protected CachedTileOutput output2;

    public TileRadioisotopeGenerator() {
        super((TileEntityType)DeferredRegisters.TILE_RADIOISOTOPEGENERATOR.get());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler());
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).voltage(Constants.RADIOISOTOPEGENERATOR_VOLTAGE).extractPower((x, y) -> TransferPack.EMPTY).output(Direction.UP).output(Direction.DOWN));
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(1).slotFaces(Integer.valueOf(0), Direction.values()).valid((slot, stack) -> RadiationRegister.get(stack.func_77973_b()) != RadiationRegister.NULL));
        this.addComponent((Component)new ComponentContainerProvider("container.radioisotopegenerator").createMenu((id, player) -> new ContainerRadioisotopeGenerator((int)id, (PlayerInventory)player, (IInventory)this.getComponent(ComponentType.Inventory), (IIntArray)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        if (this.output1 == null) {
            this.output1 = new CachedTileOutput(this.field_145850_b, this.field_174879_c.func_177972_a(Direction.UP));
        }
        if (this.output2 == null) {
            this.output2 = new CachedTileOutput(this.field_145850_b, this.field_174879_c.func_177972_a(Direction.DOWN));
        }
        if (tickable.getTicks() % 40L == 0L) {
            this.output1.update();
            this.output2.update();
        }
        ItemStack in = ((ComponentInventory)this.getComponent(ComponentType.Inventory)).func_70301_a(0);
        IRadioactiveObject rad = RadiationRegister.get(in.func_77973_b());
        double currentOutput = (double)in.func_190916_E() * Constants.RADIOISOTOPEGENERATOR_OUTPUT_MULTIPLIER * rad.getRadiationStrength();
        if (currentOutput > 0.0) {
            TransferPack transfer = TransferPack.ampsVoltage((double)(currentOutput / (Constants.RADIOISOTOPEGENERATOR_VOLTAGE * 2.0)), (double)Constants.RADIOISOTOPEGENERATOR_VOLTAGE);
            if (this.output1.valid()) {
                ElectricityUtilities.receivePower((TileEntity)((TileEntity)this.output1.getSafe()), (Direction)Direction.DOWN, (TransferPack)transfer, (boolean)false);
            }
            if (this.output2.valid()) {
                ElectricityUtilities.receivePower((TileEntity)((TileEntity)this.output2.getSafe()), (Direction)Direction.UP, (TransferPack)transfer, (boolean)false);
            }
        }
    }
}

