/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.common.recipe.ElectrodynamicsRecipe;
import electrodynamics.common.recipe.categories.o2o.O2ORecipe;
import electrodynamics.common.recipe.recipeutils.CountableIngredient;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentContainerProvider;
import electrodynamics.prefab.tile.components.type.ComponentInventory;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.Location;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import nuclearscience.DeferredRegisters;
import nuclearscience.api.radiation.RadiationSystem;
import nuclearscience.common.inventory.container.ContainerReactorCore;
import nuclearscience.common.recipe.NuclearScienceRecipeInit;
import nuclearscience.common.settings.Constants;
import nuclearscience.common.tile.TileControlRodAssembly;
import nuclearscience.common.tile.TileTurbine;

public class TileReactorCore
extends GenericTileTicking {
    public static final int MELTDOWN_TEMPERATURE_ACTUAL = 5611;
    public static final int MELTDOWN_TEMPERATURE_CALC = 4407;
    public static final int WATER_TEMPERATURE = 10;
    public static final int AIR_TEMPERATURE = 15;
    public static final int MAX_FUEL_COUNT = 12;
    public static final int STEAM_GEN_DIAMETER = 5;
    public static final int STEAM_GEN_HEIGHT = 2;
    private TileTurbine[][][] cachedTurbines = new TileTurbine[5][2][5];
    public double temperature = 15.0;
    public boolean hasDeuterium = false;
    public int ticksOverheating = 0;
    public int fuelCount = 0;
    public int ticks = 0;

    public TileReactorCore() {
        super((TileEntityType)DeferredRegisters.TILE_REACTORCORE.get());
        this.addComponent((Component)new ComponentTickable().tickCommon(this::tickCommon).tickServer(this::tickServer));
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket).guiPacketReader(this::readCustomPacket).guiPacketWriter(this::writeCustomPacket));
        this.addComponent((Component)new ComponentInventory((GenericTile)this).size(6).faceSlots(Direction.UP, new Integer[]{0, 1, 2, 3, 4}).faceSlots(Direction.DOWN, new Integer[]{5}));
        this.addComponent((Component)new ComponentContainerProvider("container.reactorcore").createMenu((id, player) -> new ContainerReactorCore((int)id, (PlayerInventory)player, (IInventory)this.getComponent(ComponentType.Inventory), (IIntArray)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean hasWater;
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        if (tickable.getTicks() % 10L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
        }
        this.fuelCount = 0;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            this.fuelCount += stack.func_77973_b() == DeferredRegisters.ITEM_FUELLEUO2.get() ? 2 : (stack.func_77973_b() == DeferredRegisters.ITEM_FUELHEUO2.get() ? 3 : (stack.func_77973_b() == DeferredRegisters.ITEM_FUELPLUTONIUM.get() ? 2 : 0));
        }
        this.hasDeuterium = !inv.func_70301_a(4).func_190926_b();
        double decrease = (this.temperature - 15.0) / 3000.0;
        if (this.fuelCount == 0) {
            decrease *= 25.0;
        }
        boolean bl = hasWater = !this.func_195044_w().func_204520_s().func_206888_e();
        if (hasWater) {
            decrease += (this.temperature - 10.0) / 5000.0;
        }
        if (decrease != 0.0) {
            this.temperature -= decrease < 0.001 && decrease > 0.0 ? 0.001 : (decrease > -0.001 && decrease < 0.0 ? -0.001 : decrease);
        }
        if (this.fuelCount > 0 && this.ticks > 50) {
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            int insertion = 0;
            if (tile instanceof TileControlRodAssembly) {
                TileControlRodAssembly assembly = (TileControlRodAssembly)tile;
                insertion = assembly.isMSR ? 0 : assembly.insertion;
            }
            double insertDecimal = (double)(100 - insertion) / 100.0;
            if ((double)this.field_145850_b.field_73012_v.nextFloat() < insertDecimal) {
                for (int slot = 0; slot < 4; ++slot) {
                    ItemStack fuelRod = inv.func_70301_a(slot);
                    if (fuelRod != ItemStack.field_190927_a && fuelRod.func_77952_i() >= fuelRod.func_77958_k()) {
                        inv.func_70299_a(slot, new ItemStack((IItemProvider)DeferredRegisters.ITEM_FUELSPENT.get()));
                    }
                    fuelRod.func_196085_b((int)((long)(fuelRod.func_77952_i() + 1) + Math.round(this.temperature) / 4407L));
                }
            }
            this.temperature += (4407.0 * insertDecimal * (0.25 * ((double)this.fuelCount / 2.0) + this.field_145850_b.field_73012_v.nextDouble() / 5.0) - this.temperature) / (200.0 + 20.0 * (hasWater ? 4.0 : 1.0));
            if (this.temperature > (double)(5611 + this.field_145850_b.field_73012_v.nextInt(50)) && this.fuelCount > 0) {
                ++this.ticksOverheating;
                if (this.ticksOverheating > 200) {
                    this.meltdown();
                }
            }
            if (this.field_145850_b.func_72912_H().func_82573_f() % 10L == 0L) {
                Location source = new Location((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f));
                double totstrength = this.temperature * 10.0;
                double range = Math.sqrt(totstrength) / (5.0 * Math.sqrt(2.0)) * 2.0;
                AxisAlignedBB bb = AxisAlignedBB.func_241550_g_((double)range, (double)range, (double)range);
                bb = bb.func_191194_a(new Vector3d(source.x(), source.y(), source.z()));
                List list = this.field_145850_b.func_217357_a(LivingEntity.class, bb);
                for (LivingEntity living : list) {
                    RadiationSystem.applyRadiation(living, source, totstrength);
                }
            }
        } else {
            this.ticksOverheating = 0;
        }
        this.temperature = Math.max(15.0, this.temperature);
        if (this.fuelCount > 0 && (double)this.field_145850_b.field_73012_v.nextFloat() < 1.0 / (5288400.0 / this.temperature)) {
            this.processFissReact(inv);
        }
    }

    protected void tickCommon(ComponentTickable tickable) {
        int n = this.ticks = this.ticks > 0x7FFFFFFD ? 0 : this.ticks + 1;
        if (this.ticks % 20 == 0) {
            this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
        }
        this.produceSteam();
    }

    public void meltdown() {
        if (!this.field_145850_b.field_72995_K) {
            int radius = 2;
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        BlockPos ppos = new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o() + j, this.field_174879_c.func_177952_p() + k);
                        BlockState state = this.field_145850_b.func_180495_p(ppos);
                        if (state.func_177230_c() != Blocks.field_150355_j) continue;
                        this.field_145850_b.func_175656_a(ppos, Blocks.field_150350_a.func_176223_P());
                    }
                }
            }
            this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            Explosion actual = new Explosion(this.field_145850_b, null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0f, new ArrayList());
            radius = 3 * this.fuelCount;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    for (int k = -radius; k <= radius; ++k) {
                        double distance;
                        BlockPos ppos = new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o() + j, this.field_174879_c.func_177952_p() + k);
                        BlockState state = this.field_145850_b.func_180495_p(ppos);
                        if (!(state.func_177230_c().getExplosionResistance(state, (IBlockReader)this.field_145850_b, ppos, actual) < (float)radius) || !((distance = Math.sqrt(i * i + j * j + k * k)) < (double)radius) || !((double)this.field_145850_b.field_73012_v.nextFloat() < 1.0 - 1.0E-4 * distance * distance * distance) || !((double)this.field_145850_b.field_73012_v.nextFloat() < 0.9)) continue;
                        this.field_145850_b.func_180495_p(ppos).onBlockExploded(this.field_145850_b, ppos, actual);
                    }
                }
            }
            this.field_145850_b.func_217385_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0f, Explosion.Mode.DESTROY);
            this.field_145850_b.func_175656_a(this.field_174879_c, DeferredRegisters.blockMeltedReactor.func_176223_P());
        }
    }

    protected void produceSteam() {
        if (this.temperature <= 400.0) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 5; ++k) {
                    boolean isFaceWater;
                    int offsetZ;
                    int offsetY;
                    boolean isReactor2d;
                    boolean bl = isReactor2d = i - 2 == 0 && k - 2 == 0;
                    if (isReactor2d && j == 0) {
                        if (this.field_145850_b.field_72995_K || !((double)this.field_145850_b.field_73012_v.nextFloat() < this.temperature / 4407000.0) || !this.field_145850_b.func_180495_p(this.field_174879_c).func_235901_b_((Property)BlockStateProperties.field_208198_y)) continue;
                        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)));
                        continue;
                    }
                    int offsetX = this.field_174879_c.func_177958_n() + i - 2;
                    BlockPos offpos = new BlockPos(offsetX, offsetY = this.field_174879_c.func_177956_o() + j, offsetZ = this.field_174879_c.func_177952_p() + k - 2);
                    Block offset = this.field_145850_b.func_180495_p(offpos).func_177230_c();
                    if (offset != Blocks.field_150355_j) continue;
                    boolean bl2 = isFaceWater = this.field_145850_b.func_180495_p(new BlockPos(offsetX, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p())).func_177230_c() == Blocks.field_150355_j || this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), offsetZ)).func_177230_c() == Blocks.field_150355_j || isReactor2d;
                    if (!isFaceWater) continue;
                    if (!this.field_145850_b.field_72995_K) {
                        TileTurbine turbine = this.cachedTurbines[i][j][k];
                        if (turbine != null) {
                            if (turbine.func_145837_r()) {
                                this.cachedTurbines[i][j][k] = null;
                            }
                            turbine.addSteam((int)(Constants.FISSIONREACTOR_MAXENERGYTARGET / (500.0 * (5611.0 / this.temperature))), (int)this.temperature);
                        }
                        if ((double)this.field_145850_b.field_73012_v.nextFloat() < this.temperature / 4407000.0) {
                            this.field_145850_b.func_175656_a(offpos, Blocks.field_150350_a.func_176223_P());
                            continue;
                        }
                        if (turbine != null && !this.field_145850_b.field_147482_g.contains((Object)turbine)) continue;
                        TileEntity above = this.field_145850_b.func_175625_s(new BlockPos(offsetX, offsetY + 1, offsetZ));
                        if (above instanceof TileTurbine) {
                            this.cachedTurbines[i][j][k] = (TileTurbine)above;
                            continue;
                        }
                        this.cachedTurbines[i][j][k] = null;
                        continue;
                    }
                    if (!this.field_145850_b.field_72995_K || !((double)this.field_145850_b.field_73012_v.nextFloat() < this.temperature / 16833.0)) continue;
                    double offsetFX = (double)offsetX + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFY = (double)offsetY + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    double offsetFZ = (double)offsetZ + this.field_145850_b.field_73012_v.nextDouble() / 2.0 * (double)(this.field_145850_b.field_73012_v.nextBoolean() ? -1 : 1);
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197612_e, offsetFX + 0.5, offsetFY + (double)0.2f, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                    if (this.field_145850_b.field_73012_v.nextInt(3) != 0) continue;
                    this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, offsetFX + 0.5, offsetFY + 0.5, offsetFZ + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void writeCustomPacket(CompoundNBT tag) {
        ComponentInventory inv = (ComponentInventory)this.getComponent(ComponentType.Inventory);
        tag.func_74757_a("hasDeuterium", this.hasDeuterium);
        tag.func_74780_a("temperature", this.temperature);
        tag.func_74768_a("fuelCount", inv.func_213901_a((Item)DeferredRegisters.ITEM_FUELHEUO2.get()) + inv.func_213901_a((Item)DeferredRegisters.ITEM_FUELLEUO2.get()));
    }

    protected void readCustomPacket(CompoundNBT nbt) {
        this.hasDeuterium = nbt.func_74767_n("hasDeuterium");
        this.temperature = nbt.func_74769_h("temperature");
        this.fuelCount = nbt.func_74762_e("fuelCount");
    }

    public void processFissReact(ComponentInventory inv) {
        int inputSlot = 4;
        int outputSlot = 5;
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (input != null && !input.equals(new ItemStack((IItemProvider)Items.field_190931_a), true)) {
            Set recipes = ElectrodynamicsRecipe.findRecipesbyType(NuclearScienceRecipeInit.FISSION_REACTOR_TYPE, (World)this.field_145850_b);
            for (IRecipe iRecipe : recipes) {
                O2ORecipe recipe = (O2ORecipe)iRecipe;
                if (!recipe.matchesRecipe(input)) continue;
                if (output.func_190926_b()) {
                    inv.func_70299_a(outputSlot, recipe.func_77571_b().func_77946_l());
                    input.func_190918_g(((CountableIngredient)recipe.func_192400_c().get(0)).getStackSize());
                    continue;
                }
                if (output.func_190916_E() > output.func_77976_d() + recipe.func_77571_b().func_190916_E()) continue;
                output.func_190917_f(recipe.func_77571_b().func_190916_E());
                input.func_190918_g(((CountableIngredient)recipe.func_192400_c().get(0)).getStackSize());
            }
        }
    }
}

