/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile;

import electrodynamics.api.sound.SoundAPI;
import electrodynamics.common.network.ElectricityUtilities;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.GenericTileTicking;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.ComponentType;
import electrodynamics.prefab.tile.components.type.ComponentElectrodynamic;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.tile.components.type.ComponentTickable;
import electrodynamics.prefab.utilities.object.CachedTileOutput;
import electrodynamics.prefab.utilities.object.TransferPack;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import nuclearscience.DeferredRegisters;
import nuclearscience.SoundRegister;
import nuclearscience.common.block.BlockTurbine;

public class TileTurbine
extends GenericTileTicking {
    public static final int MAX_STEAM = 3000000;
    public int spinSpeed = 0;
    public boolean isCore;
    protected CachedTileOutput output;
    protected int currentVoltage = 0;
    protected int steam;
    protected int wait = 30;
    protected boolean hasCore;
    protected BlockPos coreLocation = BlockPos.field_177992_a;

    public AxisAlignedBB getRenderBoundingBox() {
        return this.isCore ? super.getRenderBoundingBox().func_72314_b(1.0, 0.0, 1.0) : super.getRenderBoundingBox();
    }

    public TileTurbine() {
        super((TileEntityType)DeferredRegisters.TILE_TURBINE.get());
        this.addComponent((Component)new ComponentTickable().tickServer(this::tickServer).tickClient(this::tickClient));
        this.addComponent((Component)new ComponentPacketHandler().customPacketWriter(this::writeCustomPacket).customPacketReader(this::readCustomPacket));
        this.addComponent((Component)new ComponentElectrodynamic((GenericTile)this).output(Direction.UP).setCapabilityTest(() -> !this.hasCore || this.isCore));
    }

    public void constructStructure() {
        int j;
        int i;
        int radius = 1;
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                if (i == 0 && j == 0) continue;
                TileEntity tile = this.field_145850_b.func_175625_s(new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + j));
                if (!(tile instanceof TileTurbine)) {
                    return;
                }
                TileTurbine turbine = (TileTurbine)tile;
                if (!turbine.hasCore) continue;
                return;
            }
        }
        this.isCore = true;
        for (i = -radius; i <= radius; ++i) {
            for (j = -radius; j <= radius; ++j) {
                BlockPos offset = new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + j);
                ((TileTurbine)this.field_145850_b.func_175625_s(offset)).addToStructure(this);
                BlockState state = this.field_145850_b.func_180495_p(offset);
                this.field_145850_b.func_175656_a(offset, (BlockState)state.func_206870_a((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void deconstructStructure() {
        TileTurbine core;
        if (this.isCore) {
            int radius = 1;
            for (int i = -radius; i <= radius; ++i) {
                for (int j = -radius; j <= radius; ++j) {
                    BlockPos offset;
                    TileEntity tile;
                    if (i == 0 && j == 0 || !((tile = this.field_145850_b.func_175625_s(offset = new BlockPos(this.field_174879_c.func_177958_n() + i, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + j))) instanceof TileTurbine)) continue;
                    TileTurbine turbine = (TileTurbine)tile;
                    turbine.hasCore = false;
                    turbine.coreLocation = new BlockPos(0, 0, 0);
                    BlockState state = this.field_145850_b.func_180495_p(offset);
                    if (!state.func_235901_b_((Property)BlockTurbine.RENDER)) continue;
                    this.field_145850_b.func_175656_a(offset, (BlockState)state.func_206870_a((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(true)));
                }
            }
            this.isCore = false;
            this.hasCore = false;
            this.coreLocation = new BlockPos(0, 0, 0);
            BlockState state = this.func_195044_w();
            if (state.func_235901_b_((Property)BlockTurbine.RENDER)) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockTurbine.RENDER, (Comparable)Boolean.valueOf(true)));
            }
        } else if (this.hasCore && (core = (TileTurbine)this.field_145850_b.func_175625_s(this.coreLocation)) != null) {
            core.deconstructStructure();
        }
        ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
    }

    protected void addToStructure(TileTurbine core) {
        this.coreLocation = core.field_174879_c;
        this.hasCore = true;
        ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
    }

    public void addSteam(int steam, int temp) {
        TileEntity core;
        this.steam = Math.min(3000000 * (this.isCore ? 9 : 1), this.steam + steam);
        this.currentVoltage = temp < 4300 ? 120 : (temp < 6000 ? 240 : 480);
        if (!this.isCore && this.hasCore && (core = this.field_145850_b.func_175625_s(this.coreLocation)) instanceof TileTurbine && ((TileTurbine)core).isCore) {
            TileTurbine turbine = (TileTurbine)core;
            turbine.addSteam(this.steam, temp);
            this.steam = 0;
        }
    }

    public void tickServer(ComponentTickable tickable) {
        ((ComponentElectrodynamic)this.getComponent(ComponentType.Electrodynamic)).voltage((double)this.currentVoltage);
        if (this.output == null) {
            this.output = new CachedTileOutput(this.field_145850_b, this.field_174879_c.func_177972_a(Direction.UP));
        }
        if (tickable.getTicks() % 30L == 0L) {
            ((ComponentPacketHandler)this.getComponent(ComponentType.PacketHandler)).sendCustomPacket();
            this.spinSpeed = this.currentVoltage / 120;
            this.output.update();
        }
        if (this.hasCore && !this.isCore) {
            this.currentVoltage = 0;
            return;
        }
        if (this.steam > 0 && this.currentVoltage > 0) {
            this.wait = 30;
            if (this.output.valid()) {
                TransferPack transfer = TransferPack.joulesVoltage((double)((double)this.steam * (this.hasCore ? 1.111 : 1.0)), (double)this.currentVoltage);
                ElectricityUtilities.receivePower((TileEntity)((TileEntity)this.output.getSafe()), (Direction)Direction.DOWN, (TransferPack)transfer, (boolean)false);
                this.steam = Math.max(this.steam - Math.max(75, this.steam), 0);
            }
        } else {
            if (this.wait <= 0) {
                this.currentVoltage = 0;
                this.wait = 30;
            }
            --this.wait;
        }
    }

    public void tickClient(ComponentTickable tickable) {
        if (this.spinSpeed > 0 && tickable.getTicks() % 200L == 0L) {
            SoundAPI.playSound((SoundEvent)((SoundEvent)SoundRegister.SOUND_TURBINE.get()), (SoundCategory)SoundCategory.BLOCKS, (float)1.0f, (float)1.0f, (BlockPos)this.field_174879_c);
        }
    }

    public void writeCustomPacket(CompoundNBT tag) {
        tag.func_74768_a("spinSpeed", this.spinSpeed);
        tag.func_74757_a("hasCore", this.hasCore);
        tag.func_74757_a("isCore", this.isCore);
    }

    public void readCustomPacket(CompoundNBT nbt) {
        this.spinSpeed = nbt.func_74762_e("spinSpeed");
        this.hasCore = nbt.func_74767_n("hasCore");
        this.isCore = nbt.func_74767_n("isCore");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74757_a("hasCore", this.hasCore);
        compound.func_74757_a("isCore", this.isCore);
        compound.func_74768_a("coreX", this.coreLocation.func_177958_n());
        compound.func_74768_a("coreY", this.coreLocation.func_177956_o());
        compound.func_74768_a("coreZ", this.coreLocation.func_177952_p());
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.hasCore = compound.func_74767_n("hasCore");
        this.isCore = compound.func_74767_n("isCore");
        this.coreLocation = new BlockPos(compound.func_74762_e("coreX"), compound.func_74762_e("coreY"), compound.func_74762_e("coreZ"));
    }
}

