/*
 * Decompiled with CFR 0.152.
 */
package nuclearscience.common.tile.generic;

import com.google.common.collect.Sets;
import electrodynamics.prefab.network.AbstractNetwork;
import electrodynamics.prefab.tile.GenericTile;
import electrodynamics.prefab.tile.components.Component;
import electrodynamics.prefab.tile.components.type.ComponentPacketHandler;
import electrodynamics.prefab.utilities.Scheduler;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import nuclearscience.api.network.moltensalt.IMoltenSaltPipe;
import nuclearscience.common.network.MoltenSaltNetwork;
import nuclearscience.common.tile.TileHeatExchanger;

public abstract class GenericTileMoltenSaltPipe
extends GenericTile
implements IMoltenSaltPipe {
    public MoltenSaltNetwork moltenSaltNetwork;
    private boolean[] connections = new boolean[6];
    private TileEntity[] tileConnections = new TileEntity[6];

    public AbstractNetwork<?, ?, ?, ?> getAbstractNetwork() {
        return this.moltenSaltNetwork;
    }

    protected GenericTileMoltenSaltPipe(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.addComponent((Component)new ComponentPacketHandler().customPacketReader(this::readCustomPacket).customPacketWriter(this::writeCustomPacket));
    }

    private HashSet<IMoltenSaltPipe> getConnectedConductors() {
        HashSet<IMoltenSaltPipe> set = new HashSet<IMoltenSaltPipe>();
        for (Direction dir : Direction.values()) {
            TileEntity facing = this.field_145850_b.func_175625_s(new BlockPos((Vector3i)this.field_174879_c).func_177972_a(dir));
            if (!(facing instanceof IMoltenSaltPipe)) continue;
            set.add((IMoltenSaltPipe)facing);
        }
        return set;
    }

    public MoltenSaltNetwork getNetwork() {
        return this.getNetwork(true);
    }

    public MoltenSaltNetwork getNetwork(boolean createIfNull) {
        if (this.moltenSaltNetwork == null && createIfNull) {
            HashSet<IMoltenSaltPipe> adjacentCables = this.getConnectedConductors();
            HashSet<MoltenSaltNetwork> connectedNets = new HashSet<MoltenSaltNetwork>();
            for (IMoltenSaltPipe wire : adjacentCables) {
                if (wire.getNetwork(false) == null || !(wire.getNetwork() instanceof MoltenSaltNetwork)) continue;
                connectedNets.add((MoltenSaltNetwork)wire.getNetwork());
            }
            if (connectedNets.isEmpty()) {
                this.moltenSaltNetwork = new MoltenSaltNetwork(Sets.newHashSet((Object[])new GenericTileMoltenSaltPipe[]{this}));
            } else if (connectedNets.size() == 1) {
                this.moltenSaltNetwork = (MoltenSaltNetwork)((Object)connectedNets.toArray()[0]);
                this.moltenSaltNetwork.conductorSet.add(this);
            } else {
                this.moltenSaltNetwork = new MoltenSaltNetwork(connectedNets, false);
                this.moltenSaltNetwork.conductorSet.add(this);
            }
        }
        return this.moltenSaltNetwork;
    }

    @Override
    public void setNetwork(AbstractNetwork<?, ?, ?, ?> network) {
        if (this.moltenSaltNetwork != network && network instanceof MoltenSaltNetwork) {
            this.removeFromNetwork();
            this.moltenSaltNetwork = (MoltenSaltNetwork)network;
        }
    }

    @Override
    public void refreshNetwork() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateAdjacent();
            ArrayList<MoltenSaltNetwork> foundNetworks = new ArrayList<MoltenSaltNetwork>();
            for (Direction dir : Direction.values()) {
                TileEntity facing = this.field_145850_b.func_175625_s(new BlockPos((Vector3i)this.field_174879_c).func_177972_a(dir));
                if (!(facing instanceof IMoltenSaltPipe) || !(((IMoltenSaltPipe)facing).getNetwork() instanceof MoltenSaltNetwork)) continue;
                foundNetworks.add((MoltenSaltNetwork)((IMoltenSaltPipe)facing).getNetwork());
            }
            if (!foundNetworks.isEmpty()) {
                ((MoltenSaltNetwork)((Object)foundNetworks.get((int)0))).conductorSet.add(this);
                this.moltenSaltNetwork = (MoltenSaltNetwork)((Object)foundNetworks.get(0));
                if (foundNetworks.size() > 1) {
                    foundNetworks.remove(0);
                    for (MoltenSaltNetwork network : foundNetworks) {
                        this.getNetwork().merge(network);
                    }
                }
            }
            this.getNetwork().refresh();
        }
    }

    @Override
    public void removeFromNetwork() {
        if (this.moltenSaltNetwork != null) {
            this.moltenSaltNetwork.removeFromNetwork(this);
        }
    }

    public boolean updateAdjacent() {
        boolean flag = false;
        for (Direction dir : Direction.values()) {
            boolean is;
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(dir));
            boolean bl = is = tile instanceof IMoltenSaltPipe || tile instanceof TileHeatExchanger;
            if (this.connections[dir.ordinal()] == is) continue;
            this.connections[dir.ordinal()] = is;
            this.tileConnections[dir.ordinal()] = tile;
            flag = true;
        }
        return flag;
    }

    public TileEntity[] getAdjacentConnections() {
        return this.tileConnections;
    }

    @Override
    public void refreshNetworkIfChange() {
        if (this.updateAdjacent()) {
            this.refreshNetwork();
        }
    }

    @Override
    public void destroyViolently() {
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K && this.moltenSaltNetwork != null) {
            this.getNetwork().split(this);
        }
        super.func_145843_s();
    }

    public void onChunkUnloaded() {
        if (!this.field_145850_b.field_72995_K && this.moltenSaltNetwork != null) {
            this.getNetwork().split(this);
        }
    }

    public void onLoad() {
        super.onLoad();
        Scheduler.schedule((int)1, this::refreshNetwork);
    }

    protected abstract void writeCustomPacket(CompoundNBT var1);

    protected abstract void readCustomPacket(CompoundNBT var1);
}

